# バッチ設計書 19-test-new-tests

## 概要

本ドキュメントは、Next.jsプロジェクトにおける変更テスト自動検出・実行バッチ `test-new-tests` の設計仕様を定義する。

### 本バッチの処理概要

現在のブランチで追加・変更されたテストファイルを `origin/canary` との差分から自動検出し、dev/start/deployの各モードで実行するバッチである。フレーク検出モード（3回繰り返し実行）をサポートする。

**業務上の目的・背景**：PRで追加・変更されたテストが安定して動作するかを自動的に検証する。フレーキーテスト（不安定なテスト）はCIの信頼性を低下させるため、新規・変更テストを複数回実行して不安定性を早期に検出する仕組みが必要である。本バッチはCI環境で自動的に変更テストを検出・実行することで、フレーキーテストの混入を防止する。

**バッチの実行タイミング**：CIパイプラインでPR時に自動実行される。`origin/canary` との差分に基づいてテストファイルを検出する。

**主要な処理内容**：
1. `get-changed-tests.mjs` を呼び出し、`origin/canary` との `git diff` から変更されたテストファイルを検出する
2. テストファイルをテストモード（dev/prod/deploy）別に分類する
3. `--group` オプションによるテストの分割（CI並列実行用）を適用する
4. `--mode` で指定されたモード（dev/deploy/start）のテストを実行する
5. `--flake-detection` モードでは各テストを3回繰り返し実行する
6. フレーク検出モードかつdev/startモードではTurbopack環境変数を設定して実行する
7. deployモードではデプロイアーティファクトの存在をリトライ付きで検証する

**前後の処理との関連**：`get-changed-tests.mjs` がorigin/canaryとの差分検出を担当する。deployモードのテストでは `create-preview-tarballs`（No.9）によるアーティファクト生成が前提となる。テスト実行には `run-tests.js` を使用する。

**影響範囲**：テスト実行のみ。変更されたテストファイルのみが対象であり、全テストを実行するわけではない。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI自動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | origin/canaryとの差分が取得可能であること |
| 依存パッケージインストール済み | `pnpm install` が完了していること |
| Next.jsビルド済み | `pnpm build` が完了していること |
| canaryブランチ以外 | canaryブランチでは自動スキップされる |

### 実行可否判定

canaryブランチの場合は自動的にスキップされ、空のテストリストを返す。変更されたテストファイルが0件の場合は「No added/changed tests detected」を出力して正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --mode | string | No | なし | テストモード: `dev`, `deploy`, `start` のいずれか |
| --group | string | No | `1/1` | グループ指定: `現在グループ/合計グループ` 形式（例: `1/3`） |
| --flake-detection | boolean | No | false | フレーク検出モード。trueの場合3回繰り返し実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| git diff結果 | テキスト | `origin/canary` との差分ファイル一覧 |
| テストファイル群 | TypeScript/JavaScript | 変更されたテストファイル |
| GH_PR_NUMBER | 環境変数 | PR番号（deployモードのアーティファクトURL生成用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検出されたテストファイル一覧とテスト実行結果 |

### 出力ファイル仕様

ファイル出力はなし。テスト結果は標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. CLIオプション解析
   └─ --mode, --group, --flake-detection の値を取得
2. 変更テスト検出
   └─ getChangedTests()を呼び出し、origin/canaryとのgit diffから変更テストを検出
3. テストモード別分類
   └─ test/e2e/ → dev+prod+deploy、test/integration/ → dev+prod、
      test/prod → prod、test/development → dev
4. グループ分割
   └─ --groupで指定されたグループ数に応じてテストを均等分割
5. 空チェック
   └─ 対象テスト0件の場合はメッセージ出力して終了
6. deployモード: アーティファクト検証
   └─ PRまたはコミットのデプロイアーティファクトの存在をリトライ付きで確認
7. テスト実行
   └─ node run-tests.js -c 1 --retries 0 でテストを実行
8. フレーク検出時の繰り返し
   └─ --flake-detectionの場合は3回繰り返し実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CLIオプション解析]
    B --> C[getChangedTests呼び出し]
    C --> D{canaryブランチ?}
    D -->|Yes| E[スキップ・正常終了]
    D -->|No| F[モード別テスト分類]
    F --> G[グループ分割]
    G --> H{対象テスト0件?}
    H -->|Yes| I[No tests detected出力]
    H -->|No| J{deployモード?}
    J -->|Yes| K[アーティファクト検証<br/>リトライ付きfetch]
    J -->|No| L{flake-detection?}
    K --> L
    L -->|Yes & 非deploy| M[Turbopackモードで3回実行]
    L -->|Yes & deploy| N[Webpackモードで3回実行]
    L -->|No| O[1回実行]
    M --> P[結果出力]
    N --> P
    O --> P
    I --> Q[バッチ終了]
    E --> Q
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | テスト失敗 | 1つ以上のテストが失敗した場合 | 失敗テストの内容を確認し修正 |
| - | modeエラー | --modeがdev/deploy/start以外の場合 | 正しいモードを指定 |
| - | git diffエラー | origin/canaryとの差分取得に失敗 | リモートの最新情報をfetchして再実行 |
| - | アーティファクト未発見 | deployモードでアーティファクトが404 | Preview tarballs生成ジョブ完了後に再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | テスト実行: 0回（--retries 0）。アーティファクト検証: 5回 |
| リトライ間隔 | アーティファクト検証: 5秒 |
| リトライ対象エラー | アーティファクトHTTP応答失敗 |

### 障害時対応

git diff失敗時はorigin/canaryのfetchを行い再実行する。アーティファクト未発見時は、CI上の「Deploy Preview tarball」ジョブの完了を待ってから再実行する。テスト失敗時はフレーキーテストの可能性を含め、失敗内容を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変更テスト数件〜数十件 |
| 目標処理時間 | 30分以内（フレーク検出モード時は90分以内） |
| メモリ使用量上限 | 4096MB |

## 排他制御

同一PRに対して同時実行された場合はgit diff結果が同一となるため、テスト結果に影響はない。ポートの動的割り当てにより並列実行時の衝突を回避する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 差分情報ログ | 差分検出後 | ブランチ名、リモートURL、コミットSHA、git diff結果 |
| テスト検出ログ | テスト分類後 | devTests, prodTests, deployTestsの一覧（JSON形式） |
| 実行ログ | テスト実行時 | Run X/Y for <mode> tests |
| アーティファクトログ | deploy時 | アーティファクト検証状況 |
| エラーログ | エラー発生時 | エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗数 | 1件以上 | CI（GitHub Actions） |
| フレーキーテスト | 3回中1回以上失敗 | CI |

## 備考

- 実行スクリプト: `scripts/test-new-tests.mjs`
- 差分検出: `scripts/get-changed-tests.mjs`
- テスト実行: `run-tests.js -c 1 --retries 0`（並列度1、リトライなし）
- テストファイルの分類ロジック:
  - `test/e2e/` → devTests + prodTests + deployTests
  - `test/integration/` → devTests + prodTests
  - `test/prod` → prodTests
  - `test/development` → devTests
- フレーク検出モードでの非deployテストはTurbopack環境（IS_TURBOPACK_TEST=1）で実行される
- deployモードでのアーティファクトURL: `https://vercel-packages.vercel.app/next/prs/{PR_NUMBER}/next` または `https://vercel-packages.vercel.app/next/commits/{commitSha}/next`
- NEXT_EXTERNAL_TESTS_FILTERS: deployモード時にデフォルトで `test/deploy-tests-manifest.json` を適用
