# バッチ設計書 20-next-test

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるCLIテストコマンド `next test`（`next experimental-test`）の設計仕様を定義する。

### 本バッチの処理概要

Playwrightテストランナーを使用したテスト実行をサポートするNext.js CLIコマンドである。プロジェクトのテスト環境の自動セットアップ（依存パッケージのインストール、設定ファイル生成）からテスト実行までを一貫して提供する。

**業務上の目的・背景**：Next.jsアプリケーション開発者がE2Eテストを簡単に実行できるようにするためのCLIインターフェースを提供する。Playwrightの設定やインストールを自動化し、テスト実行のための障壁を下げることで、アプリケーション品質の向上を支援する。`experimental.testProxy` 設定を前提としたテストプロキシ機能との統合を提供する。

**バッチの実行タイミング**：開発者がアプリケーションのE2Eテストを実行したい任意のタイミングで手動実行する。

**主要な処理内容**：
1. プロジェクトディレクトリの検出と Next.js 設定の読み込みを行う
2. `experimental.testProxy: true` 設定の存在を検証する
3. テストランナー（デフォルト: Playwright）を決定する（CLIオプション > next.config > デフォルト）
4. 必要な依存パッケージ（`@playwright/test`）が未インストールの場合、自動インストールする
5. Playwrightブラウザバイナリの自動インストール（`playwright install`）を実行する
6. Playwright設定ファイ（`playwright.config.ts` / `playwright.config.js`）が存在しない場合、デフォルト設定を生成する
7. 設定ファイルが存在する場合、`playwright test` コマンドを実行する

**前後の処理との関連**：本コマンドはNext.jsアプリケーション開発者向けのCLIツールであり、フレームワーク内部のテストバッチ（No.13-19）とは用途が異なる。`next build`（No.1）で生成されたアプリケーションに対してテストを実行する。

**影響範囲**：プロジェクトディレクトリ内のファイルに影響する。具体的には、`@playwright/test` パッケージの自動インストール、`playwright.config.ts/js` ファイルの自動生成が行われる場合がある。

## バッチ種別

テスト実行（CLIコマンド）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（`next experimental-test` コマンド） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Next.jsプロジェクト | 有効なnext.config.js/tsが存在すること |
| experimental.testProxy設定 | `experimental: { testProxy: true }` が設定されていること |
| Node.js 20.9.0以上 | package.jsonのengines制約を満たすこと |

### 実行可否判定

`experimental.testProxy: true` が設定されていない場合、エラーメッセージを表示して終了する。サポートされていないテストランナーが指定された場合もエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| directory | string | No | カレントディレクトリ | Next.jsプロジェクトディレクトリ。テストランナーの引数としても解釈される |
| --test-runner | string | No | `playwright` | テストランナー名。現在は`playwright`のみサポート |
| testRunnerArgs | string[] | No | [] | テストランナーに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| next.config.js/ts | JavaScript/TypeScript | Next.js設定ファイル（experimental.testProxy, experimental.defaultTestRunner） |
| playwright.config.ts/js | TypeScript/JavaScript | Playwright設定ファイル（存在する場合） |
| テストファイル群 | TypeScript/JavaScript | Playwrightテストファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Playwrightテスト結果 |
| playwright.config.ts/js | TypeScript/JavaScript | 設定ファイルが未存在の場合に自動生成 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `playwright.config.ts`（TypeScript使用時）または `playwright.config.js` |
| 出力先 | プロジェクトルートディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

自動生成されるPlaywright設定ファイルの内容:
- TypeScript版: `import { defineConfig } from 'next/experimental/testmode/playwright'` を使用
- JavaScript版: `const { defineConfig } = require('next/experimental/testmode/playwright')` を使用

## 処理フロー

### 処理シーケンス

```
1. ディレクトリ解決
   └─ directory引数が有効なパスかつNext.jsプロジェクトかを判定
   └─ 無効な場合はテストランナー引数として扱い、カレントディレクトリを使用
2. Next.js設定読み込み
   └─ loadConfig(PHASE_PRODUCTION_BUILD, baseDir) で設定を読み込み
3. testProxy設定検証
   └─ experimental.testProxy: true の確認。未設定時はエラー終了
4. テストランナー決定
   └─ --test-runner > experimental.defaultTestRunner > 'playwright' の優先順位
5. サポートチェック
   └─ 現在は'playwright'のみサポート。それ以外はエラー終了
6. 依存パッケージ確認
   └─ @playwright/test パッケージの存在確認
7. 自動インストール（必要時）
   └─ パッケージ未インストール時にinstallDependenciesとplaywright installを実行
8. 設定ファイル確認
   └─ playwright.config.js / playwright.config.ts をfindUpで検索
9a. 設定ファイル未存在時: 設定ファイル生成
   └─ TypeScript判定後、デフォルトplaywright設定ファイルを生成して終了
9b. 設定ファイル存在時: テスト実行
   └─ playwright test コマンドをtestRunnerArgs付きで実行
```

### フローチャート

```mermaid
flowchart TD
    A[next experimental-test実行] --> B[ディレクトリ解決]
    B --> C[Next.js設定読み込み]
    C --> D{testProxy: true?}
    D -->|No| E[エラーメッセージ出力・終了]
    D -->|Yes| F[テストランナー決定]
    F --> G{サポート済みランナー?}
    G -->|No| H[未サポートエラー・終了]
    G -->|Yes| I[@playwright/testインストール確認]
    I --> J{パッケージ存在?}
    J -->|No| K[自動インストール]
    J -->|Yes| L[playwright.config検索]
    K --> M[playwright install実行]
    M --> L
    L --> N{設定ファイル存在?}
    N -->|No| O[TypeScript判定]
    O --> P[デフォルト設定ファイル生成]
    P --> Q[生成完了メッセージ出力・終了]
    N -->|Yes| R[playwright test実行]
    R --> S[テスト結果出力]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定エラー | experimental.testProxyが未設定 | next.config.jsにexperimental.testProxy: trueを追加 |
| - | ランナー未サポート | playwright以外のランナーを指定 | playwrightを使用するか、サポート追加を待つ |
| - | インストール失敗 | @playwright/testのインストールに失敗 | ネットワーク接続確認、手動でnpm install |
| - | テスト失敗 | Playwrightテストが失敗 | テスト内容を確認し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（Playwright側の設定に依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

インストール失敗時は手動で `npm install @playwright/test` と `npx playwright install` を実行する。設定エラーの場合はnext.config.jsの内容を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト内のテスト数に依存 |
| 目標処理時間 | テスト数に依存 |
| メモリ使用量上限 | 2048MB |

## 排他制御

同一プロジェクトでの同時実行は推奨しない。設定ファイル生成時にレースコンディションが発生する可能性がある。テスト実行自体はPlaywrightの排他制御に依存する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定生成ログ | 設定ファイル生成時 | "Successfully generated playwright.config.ts" |
| エラーログ | 設定エラー時 | testProxy設定に関するエラーメッセージ |
| テストログ | テスト実行時 | Playwrightの標準テスト出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗数 | 1件以上 | コンソール |

## 備考

- 実行スクリプト: `packages/next/src/cli/next-test.ts`
- CLIコマンド: `next experimental-test`
- サポートされるテストランナー: `playwright` のみ（`SUPPORTED_TEST_RUNNERS_LIST`で定義）
- テストランナーの優先順位: `--test-runner` オプション > `next.config.js` の `experimental.defaultTestRunner` > デフォルト `playwright`
- directory引数の二重解釈: ディレクトリとして無効またはNext.jsプロジェクトでない場合、テストランナーへの引数として自動的にフォールバックする
- Playwright設定ファイルの自動生成は `next/experimental/testmode/playwright` のdefineConfigを使用する
- TypeScript/JavaScript の判定は `verifyTypeScriptSetup` によるtsconfig.json検出で行われる
- `@playwright/test` パッケージが未インストールの場合、`installDependencies` で自動インストール後に `playwright install` でブラウザバイナリもインストールする
