# バッチ設計書 21-lint

## 概要

本ドキュメントは、Next.jsモノレポにおける総合的なコード品質検証バッチ「lint」の設計を記述する。TypeScript型チェック、Prettier、ESLint、ast-grepルール、言語チェックを並列実行し、コードベース全体の品質を担保する。

### 本バッチの処理概要

lintバッチは、Next.jsモノレポ全体に対して複数の静的解析ツールを並列に実行し、コードの型安全性、フォーマット整合性、コーディング規約準拠、構文パターン違反、および言語品質（包括的言語チェック）を一括検証する。

**業務上の目的・背景**：Next.jsは大規模なオープンソースプロジェクトであり、多数のコントリビューターが同時に開発を行う。コードベースの品質を一定水準に維持するために、型チェック・フォーマット・リンティング・言語チェックを統合的に実行するバッチが必要である。CI環境でのゲートキーパーとして機能し、品質基準を満たさないコードのマージを防止する。

**バッチの実行タイミング**：CI/CDパイプラインにおけるPull Request作成・更新時、およびローカル開発環境での手動実行（随時）。

**主要な処理内容**：
1. TypeScript型チェック（`tsc --noEmit`による`test-types`）
2. TypeScript型チェック（turbo経由の`lint-typescript`）
3. Prettierフォーマットチェック（`prettier --check .`）
4. ESLintルールチェック（`eslint --config eslint.cli.config.mjs .`）
5. ast-grepによる構文パターンチェック（`ast-grep scan`）
6. alexによる言語チェック（`alex .`）

**前後の処理との関連**：ビルドバッチ（next build）の実行前にコード品質を検証する目的で実行される。lint-fix（No.22）は本バッチで検出された問題を自動修正するための関連バッチである。

**影響範囲**：モノレポ全体のソースコードが検証対象。検証結果はCIのパスまたは失敗として反映され、PRのマージ可否に影響する。

## バッチ種別

コード品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CD（PR作成・更新時）、手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | package.jsonのenginesで指定 |
| pnpm 9.6.0 | パッケージマネージャのバージョン |
| 依存パッケージインストール済み | pnpm installが完了していること |

### 実行可否判定

特別な実行可否判定ロジックはない。依存パッケージがインストールされていれば常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| モノレポ全ソースコード | TypeScript/JavaScript/MDX等 | リンティング対象のソースファイル群 |
| tsconfig.json | JSON | TypeScript型チェック設定 |
| eslint.cli.config.mjs | JavaScript | ESLint設定ファイル |
| .prettierrc / prettier設定 | 設定ファイル | Prettierフォーマット設定 |
| sgconfig.yml | YAML | ast-grepルール設定 |
| .alexrc | 設定ファイル | alex言語チェック設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各ツールの検証結果・エラーメッセージ |
| 終了コード | 数値 | 0: 全チェック成功、非0: いずれかのチェック失敗 |

### 出力ファイル仕様

ファイル出力はない。結果は標準出力およびプロセス終了コードで伝達される。

## 処理フロー

### 処理シーケンス

```
1. run-pによる並列実行開始
   └─ npm-run-allのrun-pコマンドで以下を同時実行
2. test-types（tsc --noEmit）
   └─ TypeScript設定に基づく型チェック
3. lint-typescript（turbo run typescript）
   └─ 各パッケージのTypeScript型チェック
4. prettier-check（prettier --check .）
   └─ コードフォーマット整合性チェック
5. lint-eslint .（eslint --config eslint.cli.config.mjs .）
   └─ ESLintルールに基づくコード検査
6. lint-ast-grep（ast-grep scan）
   └─ 構文パターンルールに基づくコード検査
7. lint-language（alex .）
   └─ 包括的言語使用の検査
8. 全並列タスクの終了を待機
   └─ いずれかが失敗した場合、非0終了コードを返す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: pnpm lint] --> B[run-p 並列実行]
    B --> C1[test-types]
    B --> C2[lint-typescript]
    B --> C3[prettier-check]
    B --> C4[lint-eslint]
    B --> C5[lint-ast-grep]
    B --> C6[lint-language]
    C1 --> D{全タスク完了}
    C2 --> D
    C3 --> D
    C4 --> D
    C5 --> D
    C6 --> D
    D -->|全て成功| E[終了コード 0]
    D -->|いずれか失敗| F[終了コード 非0]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | 型チェックエラー | TypeScript型不整合 | ソースコードの型エラーを修正 |
| 非0終了 | フォーマットエラー | Prettierフォーマット違反 | `pnpm prettier-fix`を実行 |
| 非0終了 | ESLintエラー | ESLintルール違反 | `pnpm lint-fix`を実行または手動修正 |
| 非0終了 | ast-grepエラー | 構文パターン違反 | 該当コードを手動修正 |
| 非0終了 | 言語チェックエラー | 非包括的言語の使用 | 該当箇所の言語を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（静的解析のためリトライ不要） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

バッチ失敗時は、各ツールの出力メッセージに従い該当ソースコードを修正する。`pnpm lint-fix`で自動修正可能な問題はlint-fixバッチを使用する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | モノレポ全ファイル（数千ファイル） |
| 目標処理時間 | 明示的な上限なし（CIタイムアウトに依存） |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

同時実行は可能。読み取り専用の処理であり、ファイルの変更は行わないため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ツール開始時 | ツール名と対象範囲 |
| エラーログ | エラー検出時 | ファイル名、行番号、エラー内容 |
| 終了ログ | 各ツール完了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | 失敗時 | GitHub PR ステータスチェック |

## 備考

- `run-p`は`npm-run-all`パッケージの並列実行コマンドである
- lintスクリプトの定義: `run-p test-types lint-typescript prettier-check "lint-eslint ." lint-ast-grep lint-language`
- 個別ツールの実行も可能（例: `pnpm prettier-check`）
