# バッチ設計書 22-lint-fix

## 概要

本ドキュメントは、Next.jsモノレポにおけるコード品質自動修正バッチ「lint-fix」の設計を記述する。PrettierとESLintの自動修正を順次実行し、コードフォーマットとリンティング問題を自動的に修正する。

### 本バッチの処理概要

lint-fixバッチは、コードベース全体に対してPrettierによるフォーマット修正とESLintによるルール違反の自動修正を順次実行する。lintバッチ（No.21）で検出された問題のうち、自動修正可能なものを一括で修正する。

**業務上の目的・背景**：大規模なコードベースでは、フォーマットやリンティングの問題が多数発生する。手動での修正は非効率であるため、自動修正可能な問題を一括で処理するバッチが必要である。開発者の生産性向上とコードレビューの負荷軽減を目的とする。

**バッチの実行タイミング**：ローカル開発環境での手動実行（随時）。lintバッチでエラーが検出された後に実行されることが多い。

**主要な処理内容**：
1. Prettierによるコードフォーマット自動修正（`prettier --write .`）
2. ESLintによるルール違反の自動修正（`eslint --config eslint.cli.config.mjs --fix .`）

**前後の処理との関連**：lint（No.21）バッチで検出された問題を修正する。修正後に再度lintバッチを実行して問題が解決されたことを確認する。

**影響範囲**：モノレポ全体のソースコードが修正対象。ファイルの内容が直接変更されるため、Git差分に影響する。

## バッチ種別

コード自動修正

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | package.jsonのenginesで指定 |
| pnpm 9.6.0 | パッケージマネージャのバージョン |
| 依存パッケージインストール済み | pnpm installが完了していること |

### 実行可否判定

特別な実行可否判定ロジックはない。依存パッケージがインストールされていれば常に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| モノレポ全ソースコード | TypeScript/JavaScript/MDX等 | 修正対象のソースファイル群 |
| eslint.cli.config.mjs | JavaScript | ESLint設定ファイル |
| .prettierrc / prettier設定 | 設定ファイル | Prettierフォーマット設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ソースファイル（上書き） | TypeScript/JavaScript等 | フォーマット・リンティング修正済みファイル |
| 標準出力 | テキスト | 修正結果のログ |

### 出力ファイル仕様

修正はソースファイルへの直接上書きで行われる。Prettierは`--write`フラグ、ESLintは`--fix`フラグにより対象ファイルを直接変更する。

## 処理フロー

### 処理シーケンス

```
1. Prettierフォーマット修正（prettier --write .）
   └─ モノレポ全体のファイルをフォーマット修正
2. ESLint自動修正（eslint --config eslint.cli.config.mjs --fix .）
   └─ ESLintルールに基づく自動修正可能な問題を修正
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: pnpm lint-fix] --> B[prettier --write .]
    B --> C{Prettier成功?}
    C -->|はい| D[eslint --fix .]
    C -->|いいえ| E[エラー終了]
    D --> F{ESLint成功?}
    F -->|はい| G[終了コード 0]
    F -->|いいえ| H[終了コード 非0]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | Prettierエラー | 構文エラーによりパースできないファイルがある | 構文エラーを手動修正後に再実行 |
| 非0終了 | ESLintエラー | 自動修正不可能なルール違反がある | 該当箇所を手動修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

自動修正不可能なエラーが残存する場合は、エラーメッセージに従い手動修正を行う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | git resetで変更を取り消し可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | モノレポ全ファイル（数千ファイル） |
| 目標処理時間 | 明示的な上限なし |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

他のファイル変更処理との同時実行は避けるべきである。Prettier/ESLintがファイルを上書きするため、同時に他のプロセスが同じファイルを変更すると競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 修正ログ | ファイル修正時 | 修正されたファイル名 |
| エラーログ | エラー発生時 | 自動修正不可能なエラーの詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- lint-fixはPrettierを先に実行し、その後ESLintを実行する順次処理である
- スクリプト定義: `pnpm prettier-fix && pnpm lint-eslint --fix .`
- `&&`による連結のため、Prettierが失敗した場合ESLintは実行されない
