# バッチ設計書 23-check-precompiled

## 概要

本ドキュメントは、Next.jsパッケージにおけるプリコンパイル済みファイルの整合性検証バッチ「check-precompiled」の設計を記述する。webpackのHMRランタイムファイルをコピーし、ncc-compiledを実行した後、Gitの差分を検出して整合性を検証する。

### 本バッチの処理概要

check-precompiledバッチは、packages/nextディレクトリにおいて、webpackのHMR（Hot Module Replacement）ランタイムファイルをnode_modulesからソースディレクトリにコピーし、ncc-compiledタスクを実行した後、Git上の変更差分を検出することでプリコンパイル済みファイルの整合性を検証する。

**業務上の目的・背景**：Next.jsはwebpackのランタイムファイルやnccでバンドルされた依存パッケージをプリコンパイル済みファイルとしてリポジトリに含めている。これらのファイルが依存パッケージの更新に追従しているか、またはビルド成果物が最新であるかを検証する必要がある。CI環境でこのチェックを行うことで、古いプリコンパイルファイルがマージされることを防止する。

**バッチの実行タイミング**：CI/CDパイプラインにおけるPull Request作成・更新時。`types-and-precompiled`タスクの一部として`lint-typescript`の後に実行される。

**主要な処理内容**：
1. packages/nextディレクトリに移動
2. webpackのHMRランタイムファイル4つをnode_modulesからsrc/bundles/webpack/packages/にコピー
3. `pnpm run ncc-compiled`を実行してプリコンパイルファイルを再生成
4. `git status -s`で変更差分を検出
5. 差分がある場合はエラー終了（exit 1）

**前後の処理との関連**：`types-and-precompiled`スクリプト内で`lint-typescript`や`check-compiler-fixtures`、`types:test-lib`と並列実行された後に呼び出される。ビルドバッチ（next build）とは独立した検証プロセスである。

**影響範囲**：packages/next配下のプリコンパイル済みファイル（src/bundles/webpack/packages/）。CIの成否に直接影響する。

## バッチ種別

整合性検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CD（PR作成・更新時）、手動実行（`pnpm check-precompiled`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | package.jsonのenginesで指定 |
| pnpm 9.6.0 | パッケージマネージャのバージョン |
| 依存パッケージインストール済み | pnpm installが完了していること |
| Gitリポジトリ | git statusコマンドの実行にGitリポジトリが必要 |

### 実行可否判定

Gitリポジトリ内で依存パッケージがインストールされていれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node_modules/webpack/lib/hmr/ | JavaScript | webpackのHMRランタイムファイル |
| node_modules/webpack/hot/ | JavaScript | webpackのlazy compilationファイル |
| packages/next/src/bundles/ | JavaScript | 既存のプリコンパイル済みファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 変更検出結果とgit diff統計 |
| 終了コード | 数値 | 0: 変更なし（整合性OK）、1: 変更あり（整合性NG） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | HotModuleReplacement.runtime.js, JavascriptHotModuleReplacement.runtime.js, lazy-compilation-node.js, lazy-compilation-web.js |
| 出力先 | packages/next/src/bundles/webpack/packages/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. packages/nextディレクトリに移動
   └─ cd packages/next
2. webpackのHMRランタイムファイルをコピー
   └─ 4つのファイルをnode_modulesからsrc/bundles/webpack/packages/にコピー
3. ncc-compiledタスクを実行
   └─ pnpm run ncc-compiledでプリコンパイルファイルを再生成
4. リポジトリルートに戻る
   └─ cd ../../
5. Git差分チェック
   └─ git status -sで変更を検出
6. 結果判定
   └─ 変更があればgit diff統計を表示してexit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[packages/nextに移動]
    B --> C[webpack HMRファイル4つをコピー]
    C --> D[pnpm run ncc-compiled実行]
    D --> E[リポジトリルートに戻る]
    E --> F{git status -s で変更あり?}
    F -->|なし| G[終了コード 0]
    F -->|あり| H[git diff -a --stat 表示]
    H --> I[終了コード 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 整合性不一致 | ncc-compiled実行後にGit差分が検出された | `pnpm --filter=next run ncc-compiled`を実行し変更をコミット |
| 非0終了 | cpコマンドエラー | node_modulesにwebpackがインストールされていない | `pnpm install`を実行 |
| 非0終了 | ncc-compiledエラー | ビルドプロセスでのエラー | エラーメッセージに従い対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

整合性不一致が検出された場合は、ローカルで`pnpm --filter=next run ncc-compiled`を実行し、生成されたファイルの変更をGitにコミットする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし（検証目的のため） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プリコンパイル対象ファイル群 |
| 目標処理時間 | 明示的な上限なし（ncc-compiledの実行時間に依存） |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

`set -e`によりエラー発生時に即座に処理を中断する。並列実行は推奨されない（Git statusに影響するため）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 差分検出ログ | 差分検出時 | "Detected changes" メッセージ |
| 差分統計ログ | 差分検出時 | git diff -a --stat の出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | 失敗時 | GitHub PR ステータスチェック |

## 備考

- `set -e`により、スクリプト内のいずれかのコマンドが失敗した場合は即座に終了する
- スクリプトパス: `scripts/check-pre-compiled.sh`
- package.jsonでの呼び出し: `"check-precompiled": "./scripts/check-pre-compiled.sh"`
- `types-and-precompiled`タスク内で使用: `run-p "lint-typescript --log-order=stream" check-compiler-fixtures types:test-lib && pnpm check-precompiled`
