# バッチ設計書 24-check-manifests

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるエラーマニフェストファイルの整合性検証バッチ「check-manifests」の設計を記述する。errors/manifest.jsonに記載されたパスとerrors/ディレクトリ内のMarkdownファイルの対応関係を検証する。

### 本バッチの処理概要

check-manifestsバッチは、`errors/manifest.json`に定義されたルーティングパスと`errors/`ディレクトリ内の実際のMarkdownファイルとの整合性を双方向で検証する。マニフェストに記載されていないファイルや、マニフェストに記載されているが実ファイルが存在しないパスを検出する。

**業務上の目的・背景**：Next.jsはユーザー向けのエラーメッセージドキュメントを`errors/`ディレクトリに格納しており、`manifest.json`によりルーティング構造を管理している。新しいエラードキュメントの追加やパスの変更時に、マニフェストとファイルの不整合が発生する可能性がある。このバッチにより、エラードキュメントの欠落やマニフェストの記載漏れを自動検出する。

**バッチの実行タイミング**：CI/CDパイプラインにおけるPull Request作成・更新時、およびローカル開発環境での手動実行。

**主要な処理内容**：
1. `errors/manifest.json`を読み込み、定義されたルーティングパスを抽出
2. `errors/`ディレクトリ内の全Markdownファイルを走査
3. マニフェストに未登録のファイルを検出（template.mdを除外）
4. マニフェストに登録されているがファイルが存在しないパスを検出
5. 不整合がある場合はエラー終了

**前後の処理との関連**：エラーコード管理に関連するバッチ群（check-error-codes（No.26）、update-error-codes（No.27））と関連する。新しいエラーが追加された際にドキュメントとマニフェストの同期が必要となる。

**影響範囲**：`errors/`ディレクトリ内のMarkdownドキュメントと`errors/manifest.json`。CIの成否に影響する。

## バッチ種別

整合性検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CD（PR作成・更新時）、手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | package.jsonのenginesで指定 |
| errors/manifest.json | エラードキュメントのマニフェストファイルが存在すること |
| globパッケージ | devDependenciesに含まれていること |

### 実行可否判定

`errors/manifest.json`が存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| errors/manifest.json | JSON | エラードキュメントのルーティング定義 |
| errors/**/*.md | Markdown | エラードキュメントファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証結果メッセージ（成功: "success"、失敗: 不整合の詳細） |
| 標準エラー出力 | テキスト | エラーメッセージ |
| 終了コード | 数値 | 0: 整合性OK、1: 整合性NG |

### 出力ファイル仕様

ファイル出力はない。

## 処理フロー

### 処理シーケンス

```
1. errors/manifest.jsonを読み込み
   └─ JSONパースしてルーティング定義を取得
2. ルーティングパスの再帰的抽出
   └─ collectPaths関数でroutes配列からパスを収集（redirectを除外）
3. errors/ディレクトリのMarkdownファイル走査
   └─ globパターン errors/**/*.md でファイル一覧を取得
4. マニフェスト未登録ファイルの検出
   └─ ファイルがpathsに含まれないものを検出（template.mdを除外）
5. 実ファイル不在パスの検出
   └─ マニフェストのパスに対応するファイルの存在チェック
6. 結果判定
   └─ 不整合があればエラーメッセージを表示してexit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[errors/manifest.json読み込み]
    B --> C[ルーティングパス抽出]
    C --> D[errors/**/*.md ファイル一覧取得]
    D --> E{マニフェスト未登録ファイルあり?}
    E -->|あり| F[未登録ファイル一覧を出力]
    E -->|なし| G[No missing paths メッセージ]
    F --> H{マニフェストのパスに実ファイル不在?}
    G --> H
    H -->|あり| I[不在パスを出力]
    H -->|なし| J{エラーあり?}
    I --> J
    J -->|あり| K[throw Error / exit 1]
    J -->|なし| L[success / exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | マニフェスト未登録 | errors/ディレクトリにファイルがあるがmanifest.jsonに未登録 | manifest.jsonにパスを追加 |
| 1 | ファイル不在 | manifest.jsonにパスがあるがファイルが存在しない | 対応するMarkdownファイルを作成またはmanifest.jsonからパスを削除 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

不整合が検出された場合は、出力されたメッセージに従い`errors/manifest.json`またはエラードキュメントファイルを修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | errors/ディレクトリ内のMarkdownファイル数（数十〜数百ファイル） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

読み取り専用の処理であり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 検証結果ログ | 検証完了時 | "No missing paths in manifest" または不整合ファイル一覧 |
| 成功ログ | 成功時 | "success" |
| エラーログ | 失敗時 | "missing/incorrect manifest items detected see above" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | 失敗時 | GitHub PR ステータスチェック |

## 備考

- スクリプトパス: `scripts/check-manifests.js`
- `errors/template.md`は検証対象から除外される
- マニフェスト内のリダイレクトパスは検証対象から除外される（`route.redirect`が存在する場合はスキップ）
- collectPaths関数はroutesの入れ子構造を再帰的に走査する
