# バッチ設計書 25-validate-externals-doc

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるサーバー外部パッケージリストとドキュメントの整合性検証バッチ「validate-externals-doc」の設計を記述する。`server-external-packages.jsonc`に定義されたパッケージリストとApp Router/Pages Routerの各ドキュメントの記載内容を比較検証する。

### 本バッチの処理概要

validate-externals-docバッチは、`packages/next/src/lib/server-external-packages.jsonc`に定義されたサーバー外部パッケージのリストと、App RouterおよびPages Routerの`serverExternalPackages`ドキュメント（MDXファイル）に記載されたパッケージリストを比較し、過不足がないかを検証する。

**業務上の目的・背景**：Next.jsはサーバーサイドで外部化するパッケージのリストをJSONCファイルで管理しており、同時にユーザー向けドキュメントにも同じリストが記載されている。パッケージの追加・削除時に、ソースコードとドキュメントの同期が漏れる可能性がある。このバッチにより、ドキュメントの正確性を自動的に担保する。

**バッチの実行タイミング**：CI/CDパイプラインにおけるPull Request作成・更新時、およびローカル開発環境での手動実行。

**主要な処理内容**：
1. `server-external-packages.jsonc`を読み込み、外部パッケージリストを取得
2. App Routerドキュメント（`docs/01-app/.../serverExternalPackages.mdx`）を検証
3. Pages Routerドキュメント（`docs/02-pages/.../serverExternalPackages.mdx`）を検証
4. 各ドキュメントについて、余分なパッケージと不足パッケージを検出
5. 不整合がある場合はエラー終了

**前後の処理との関連**：サーバー外部パッケージリストの更新時に実行される。ドキュメントの整合性を保つために、パッケージリスト変更のPRと併せて検証される。

**影響範囲**：`server-external-packages.jsonc`と2つのドキュメントファイル（App Router / Pages Router）。CIの成否に影響する。

## バッチ種別

整合性検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CD（PR作成・更新時）、手動実行（`pnpm validate-externals-doc`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | package.jsonのenginesで指定 |
| 依存パッケージインストール済み | next/dist/compiled/json5が使用可能であること |
| ドキュメントファイルの存在 | App Router/Pages Routerの各MDXファイルが存在すること |

### 実行可否判定

`server-external-packages.jsonc`と対象MDXファイルが存在すれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next/src/lib/server-external-packages.jsonc | JSONC | サーバー外部パッケージ定義（コメント付きJSON） |
| docs/01-app/03-api-reference/05-config/01-next-config-js/serverExternalPackages.mdx | MDX | App Routerドキュメント |
| docs/02-pages/04-api-reference/04-config/01-next-config-js/serverExternalPackages.mdx | MDX | Pages Routerドキュメント |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証結果メッセージ |
| 終了コード | 数値 | 0: 整合性OK、1: 整合性NG |

### 出力ファイル仕様

ファイル出力はない。

## 処理フロー

### 処理シーケンス

```
1. server-external-packages.jsonc読み込み
   └─ JSON5でパースしてパッケージ名の配列を取得
2. App Routerドキュメント検証（validate関数）
   └─ MDXファイルを読み込み、"opt-ed out:"セクション以降のパッケージ名を抽出
   └─ ソースリストとドキュメントリストを比較
3. Pages Routerドキュメント検証（validate関数）
   └─ 同様にMDXファイルを読み込み検証
4. 結果判定
   └─ 両方のドキュメントが検証OKであれば"server externals doc is in sync"を出力
   └─ いずれかがNGであればexit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[server-external-packages.jsonc読み込み]
    B --> C[App Routerドキュメント検証]
    B --> D[Pages Routerドキュメント検証]
    C --> E{App Router整合?}
    D --> F{Pages Router整合?}
    E -->|NG| G[余分/不足パッケージを出力]
    F -->|NG| G
    E -->|OK| H{両方OK?}
    F -->|OK| H
    H -->|はい| I["server externals doc is in sync" / exit 0]
    G --> J[exit 1]
    H -->|いいえ| J
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ドキュメント同期エラー | ドキュメントにソースリストにないパッケージが含まれている | ドキュメントから余分なパッケージを削除 |
| 1 | ドキュメント同期エラー | ソースリストのパッケージがドキュメントに記載されていない | ドキュメントに不足パッケージを追加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

出力メッセージの"Extra packages included"と"Missing packages"に従い、該当ドキュメントファイルを修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パッケージリスト（数十件程度） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

読み取り専用の処理であり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 同期結果ログ | 検証完了時 | "server externals doc is in sync" または不整合の詳細 |
| 不整合詳細 | 不整合検出時 | "Extra packages included" および "Missing packages" のJSON一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| CI実行結果 | 失敗時 | GitHub PR ステータスチェック |

## 備考

- スクリプトパス: `scripts/validate-externals-doc.js`
- package.jsonでの呼び出し: `"validate-externals-doc": "node ./scripts/validate-externals-doc.js"`
- JSONCパースには`next/dist/compiled/json5`を使用
- MDXファイルのパース方法: "opt-ed out:"セクション以降を"| Version"の前まで取得し、バッククォートで囲まれたパッケージ名を抽出
