# バッチ設計書 27-update-error-codes

## 概要

本ドキュメントは、Next.jsパッケージにおけるエラーコードの更新バッチ「update-error-codes」の設計を記述する。taskrを使用してSWCプラグインによるコンパイルとエラーコードの処理を実行し、errors.jsonを更新する。

### 本バッチの処理概要

update-error-codesバッチは、packages/nextディレクトリにおいてtaskrの`compile`タスクと`check_error_codes`タスクを順次実行する。compileタスクはSWCプラグインを使用してソースコードをコンパイルし、その過程で新しいエラーメッセージを`.errors`ディレクトリに出力する。続くcheck_error_codesタスクがそれらを検出してerrors.jsonに統合する。

**業務上の目的・背景**：Next.jsは本番ビルドにおいてエラーメッセージを数値コードに置き換えることで、バンドルサイズを削減している。開発者が新しいエラーメッセージを追加した際に、対応するエラーコードをerrors.jsonに登録する必要がある。このバッチは、コンパイルとエラーコード更新を一括で実行する便利コマンドとして提供される。

**バッチの実行タイミング**：新しいエラーメッセージを追加した際の手動実行。`pnpm build`の内部でも同等の処理が実行される。

**主要な処理内容**：
1. packages/nextディレクトリに移動
2. taskrの`compile`タスクを実行（SWCプラグインによるコンパイル）
3. taskrの`check_error_codes`タスクを実行（errors.json更新）

**前後の処理との関連**：check-error-codes（No.26）の上位バッチとして機能する。ビルド（next build / No.1）プロセスの`taskr build`タスク内でも`compile`→`check_error_codes`の順で同等の処理が実行される。

**影響範囲**：`packages/next/errors.json`、`packages/next/dist/`（コンパイル成果物）、`packages/next/.errors`ディレクトリ。

## バッチ種別

コード生成 / データ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行（`pnpm update-error-codes`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | package.jsonのenginesで指定 |
| pnpm 9.6.0 | パッケージマネージャのバージョン |
| 依存パッケージインストール済み | taskrおよびSWCバインディングが使用可能であること |

### 実行可否判定

packages/nextディレクトリにtaskfile.jsが存在し、依存パッケージがインストールされていれば実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next/src/ | TypeScript | Next.jsソースコード |
| packages/next/errors.json | JSON | 既存のエラーコード定義 |
| packages/next/taskfile.js | JavaScript | taskrタスク定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| packages/next/errors.json | JSON | 更新されたエラーコード定義 |
| packages/next/dist/ | JavaScript | コンパイル済みソースコード |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | errors.json |
| 出力先 | packages/next/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（JSON形式、2スペースインデント） |

## 処理フロー

### 処理シーケンス

```
1. packages/nextディレクトリに移動
   └─ cd packages/next
2. taskr compileタスク実行
   └─ SWCプラグインによるソースコードコンパイル
   └─ 新しいエラーメッセージが.errorsディレクトリに出力される
3. taskr check_error_codesタスク実行
   └─ .errorsディレクトリのエラーファイルを検出
   └─ errors.jsonに統合
   └─ .errorsディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: pnpm update-error-codes] --> B[cd packages/next]
    B --> C[pnpm taskr compile]
    C --> D[SWCプラグインによるコンパイル]
    D --> E[.errorsディレクトリにエラーファイル生成]
    E --> F[pnpm taskr check_error_codes]
    F --> G[errors.jsonに新規エラーを統合]
    G --> H[.errorsディレクトリ削除]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0終了 | コンパイルエラー | ソースコードにコンパイルエラーがある | ソースコードのエラーを修正 |
| 1 | 新規エラー検出 | check_error_codesが新しいエラーを検出 | errors.jsonの変更をコミットする（想定通りの動作） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

コンパイルエラーが発生した場合は、ソースコードのエラーを修正して再実行する。check_error_codesのexit 1は正常な動作であり、更新されたerrors.jsonをGitにコミットすればよい。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | compile → check_error_codesの順次実行 |
| コミットタイミング | check_error_codes完了後 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | packages/nextの全ソースファイル |
| 目標処理時間 | 数分（コンパイル処理に依存） |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

ビルドプロセスと同時に実行しないことを推奨。dist/ディレクトリへの書き込みが競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コンパイルログ | compile実行中 | taskrのコンパイル進捗 |
| エラーコード更新ログ | check_error_codes実行時 | 新しいエラーコードの追加情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- スクリプト定義: `"update-error-codes": "cd packages/next && pnpm taskr compile check_error_codes"`
- `pnpm build`でも内部的に同じ`compile` → `check_error_codes`の処理が実行される
- taskrは`@taskr/esnext`プラグインを使用したタスクランナーである
