# バッチ設計書 28-merge-errors-json

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるerrors.jsonファイルのGitマージコンフリクト自動解決バッチ「merge-errors-json」の設計を記述する。Gitのカスタムマージドライバーとして機能し、3つのバージョン（current/base/other）のerrors.jsonを自動的にマージする。

### 本バッチの処理概要

merge-errors-jsonバッチは、Gitのカスタムマージドライバーとして登録され、`packages/next/errors.json`ファイルのマージコンフリクトを自動解決する。3方向マージ（3-way merge）を実行し、base（共通祖先）に対するotherの新規追加メッセージをcurrentにマージする。コンフリクトが発生する場合（同じエラーコード番号に異なるメッセージが割り当てられる場合）、新しいメッセージには次番のコード番号を割り当てることで自動解決する。

**業務上の目的・背景**：errors.jsonは自動生成されるファイルであり、複数のブランチで同時にエラーメッセージが追加されると、同じコード番号に異なるメッセージが割り当てられるコンフリクトが頻繁に発生する。手動でのコンフリクト解決は煩雑であり、機械的に解決可能な性質のコンフリクトである。このマージドライバーにより、リベースやマージ時のコンフリクト解決を自動化する。

**バッチの実行タイミング**：Gitのmerge/rebase操作時に`packages/next/errors.json`にコンフリクトが発生した際、Gitが自動的に呼び出す。

**主要な処理内容**：
1. Gitから3つのファイルバージョン（current, base, other）を受け取る
2. baseからotherへの新規追加メッセージを抽出
3. currentに対して、重複しない新規メッセージを次番コードで追加
4. マージ結果をcurrentファイルに書き出す

**前後の処理との関連**：check-error-codes（No.26）およびupdate-error-codes（No.27）で生成・更新されるerrors.jsonのマージ時に使用される。installスクリプトでGitマージドライバーの登録、uninstallスクリプトで解除が可能。

**影響範囲**：`packages/next/errors.json`。Gitのmerge/rebase操作の成否に影響する。

## バッチ種別

データ統合 / マージ自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Gitのmerge/rebase時のコンフリクト発生 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js >= 20.9.0 | スクリプト実行に必要 |
| Gitマージドライバー登録済み | `scripts/merge-errors-json/install`の実行が必要 |
| .gitattributes設定 | errors.jsonにerrors-jsonマージドライバーが指定されていること |

### 実行可否判定

Gitマージドライバーとして登録され、`.gitattributes`で`packages/next/errors.json`に対してマージドライバーが指定されていれば、Gitが自動的に呼び出す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| current | ファイルパス | Yes | - | 現在のバージョン（%A） |
| base | ファイルパス | Yes | - | 共通祖先バージョン（%O） |
| other | ファイルパス | Yes | - | 他方のバージョン（%B） |
| marker-size | 数値 | No | 7 | コンフリクトマーカーのサイズ（使用されない） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| current（%A） | JSON | 現在のブランチのerrors.json |
| base（%O） | JSON | 共通祖先のerrors.json |
| other（%B） | JSON | マージ対象ブランチのerrors.json |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| currentファイル（%A） | JSON | マージ結果（上書き） |
| 標準エラー出力 | テキスト | マージ結果のサマリー |
| 終了コード | 数値 | 0: マージ成功、1: マージ失敗 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Gitが指定するテンポラリファイル（%A） |
| 出力先 | Gitが管理 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（JSON形式、2スペースインデント + 末尾改行） |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の検証
   └─ 3つ以上の引数が必要
2. 3つのJSONファイルを読み込み
   └─ base, current, otherをそれぞれパース
3. mergeErrors関数によるマージ処理
   └─ currentをベースにresultを作成
   └─ baseからotherへの新規メッセージを抽出（getNewMessages関数）
   └─ 重複チェック（existingMessagesセットで判定）
   └─ 新規メッセージに次番キーを割り当て
4. マージ結果をcurrentファイルに書き出し
   └─ JSON.stringify(merged, null, 2) + '\n'
5. 追加件数をstderrに出力
6. exit 0で成功終了
```

### フローチャート

```mermaid
flowchart TD
    A[Gitがマージドライバーを呼び出し] --> B{引数が3つ以上?}
    B -->|いいえ| C[Usage表示 / exit 1]
    B -->|はい| D[base/current/otherの3ファイルを読み込み]
    D --> E[baseからotherへの新規メッセージを抽出]
    E --> F{各メッセージがcurrentに既存?}
    F -->|既存| G[スキップ]
    F -->|新規| H[次番キーで追加]
    G --> I[マージ結果をcurrentファイルに書き出し]
    H --> I
    I --> J[追加件数を表示]
    J --> K[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数不足 | 3つ未満の引数で呼び出された | 正しい引数で再実行（通常はGitが自動的に正しい引数を渡す） |
| 1 | マージ失敗 | JSONパースエラー等 | `scripts/merge-errors-json/uninstall`でドライバーを無効化し手動マージ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

マージ失敗時は、エラーメッセージに記載の通り`scripts/merge-errors-json/uninstall`を実行してマージドライバーを無効化し、手動でコンフリクトを解決する。または`.git/config`から`[merge "errors-json"]`セクションを手動削除する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 1ファイル（currentファイル）の書き込み |
| コミットタイミング | マージ処理完了時 |
| ロールバック条件 | マージ失敗時はGitがコンフリクト状態を維持 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | errors.json内のエントリ数（数百件程度） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 明示的な上限なし |

## 排他制御

Gitが排他制御を管理する。マージドライバーはGitプロセスから逐次呼び出される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| マージ結果ログ | マージ成功時 | "merge-errors-json: added N new message(s) to errors.json" |
| エラーログ | マージ失敗時 | "merge-errors-json: merge failed: {エラーメッセージ}" |
| 対処方法ログ | マージ失敗時 | uninstallスクリプトの案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- スクリプトパス: `scripts/merge-errors-json/merge.mjs`
- インストール: `scripts/merge-errors-json/install`（git configでマージドライバーを登録）
- アンインストール: `scripts/merge-errors-json/uninstall`（git configからマージドライバーを削除）
- Gitマージドライバー設定: `git config merge."errors-json".driver 'node scripts/merge-errors-json/merge.mjs %A %O %B'`
- マージ戦略: currentをベースとし、otherの新規メッセージを次番コードで追加する（currentのエントリは変更しない）
- メッセージの一意性は文字列完全一致で判定される
