# バッチ設計書 3-swc-build-native

## 概要

本ドキュメントは、Next.js SWCネイティブバインディング（Rust）のビルドを実行する `swc-build-native` バッチの設計書である。Cargoによるネイティブバイナリのコンパイルと型定義ファイルの生成を行う。

### 本バッチの処理概要

`swc-build-native` は、RustベースのSWC（Speedy Web Compiler）ネイティブバインディングをビルドするバッチ処理である。`packages/next-swc` ディレクトリ内のRustコードをCargo経由でコンパイルし、Node.js用のネイティブバイナリ（`.node` ファイル）と型定義ファイルを生成する。

**業務上の目的・背景**：Next.jsはSWCを使用してJavaScript/TypeScriptのトランスパイル、ミニファイ、バンドル最適化を高速に行う。SWCはRustで実装されており、N-APIを通じてNode.jsから利用される。Rustコードの変更時にネイティブバイナリを再ビルドし、Next.jsのビルドパイプラインで利用可能にする必要がある。

**バッチの実行タイミング**：随時実行。Rust/SWC関連のコード変更後、またはターゲットプラットフォームのバイナリが必要な場合に実行する。

**主要な処理内容**：
1. `packages/next-swc` ディレクトリで `pnpm run build-native` を実行（Cargoコンパイル）
2. 生成された型定義ファイル（`index.d.ts`）を読み込み
3. `packages/next/src/build/swc/generated-native.d.ts` に型定義をコピー・統合
4. Prettierによる型定義ファイルのフォーマット

**前後の処理との関連**：前提としてRust/Cargoのツールチェインがインストールされていること。後続処理として `turbo run build` や `pack-next` でネイティブバイナリが利用される。`publish-native` バッチでバイナリがnpmに公開される。

**影響範囲**：`packages/next-swc/native/` 配下のネイティブバイナリ、`packages/next/src/build/swc/generated-native.d.ts` の型定義ファイル。

## バッチ種別

ビルド処理（ネイティブバイナリコンパイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（`pnpm swc-build-native`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Rust/Cargo | Rustツールチェインがインストールされていること |
| Node.js環境 | Node.js および pnpm が利用可能であること |
| 依存関係 | `pnpm install` が完了していること |

### 実行可否判定

Cargoの実行可否はシェルの PATH に依存する。ビルド失敗時はexecaのエラーとして伝播する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| buildNativeArgs | string[] | No | [] | Cargo build-nativeに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next-swc/crates/ | Rust | SWCネイティブバインディングのRustソースコード |
| crates/ | Rust | Next.js固有のSWCトランスフォームクレート |
| Cargo.toml | TOML | Rust依存関係定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| packages/next-swc/native/*.node | バイナリ | ネイティブバイナリ（プラットフォーム固有） |
| packages/next-swc/native/index.d.ts | TypeScript | 生成された型定義ファイル |
| packages/next/src/build/swc/generated-native.d.ts | TypeScript | 統合された型定義ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | next-swc.{platform}.node |
| 出力先 | packages/next-swc/native/ |
| 文字コード | バイナリ / UTF-8（型定義） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. Cargoビルド実行
   └─ packages/next-swc で `pnpm run build-native` を実行
   └─ 環境変数: NODE_ENV, CARGO_TERM_COLOR=always, TTY=1
2. 型定義ファイル読み込み
   └─ packages/next-swc/native/index.d.ts を読み込み
3. 型定義ファイル統合
   └─ packages/next/src/build/swc/generated-native.d.ts に統合
   └─ GENERATED-TYPES-BELOW マーカー以降を置換
4. Prettierフォーマット
   └─ 統合後の型定義ファイルをPrettierで整形
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: swc-build-native] --> B[Cargo build-native 実行]
    B --> C{ビルド成功?}
    C -->|失敗| D[エラー出力して終了]
    C -->|成功| E[生成型定義ファイル読み込み]
    E --> F[vendored型定義ファイル読み込み]
    F --> G[GENERATED-TYPES-BELOWマーカーで分割]
    G --> H[型定義統合・書き込み]
    H --> I[Prettierフォーマット]
    I --> J[バッチ終了]
    D --> K[バッチ終了: 異常]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CARGO_BUILD_FAILED | コンパイルエラー | Rustコードのコンパイル失敗 | Rustコードのエラーを修正、`cargo fmt` を実行 |
| ENOENT | ファイル不在 | 型定義ファイルが生成されていない | Cargoビルドの出力を確認 |
| PRETTIER_ERROR | フォーマットエラー | Prettierの実行失敗 | Prettierの設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

コンパイルエラー時は Rust コードを修正して再実行する。ICE（Internal Compiler Error）の場合は `target/*/incremental` ディレクトリを削除してから再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作のみ |
| コミットタイミング | 各ファイル書き込み時 |
| ロールバック条件 | なし（途中失敗時は不完全な成果物が残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルドで1つのネイティブバイナリ |
| 目標処理時間 | インクリメンタルビルド: 数十秒、フルビルド: 数分～十数分 |
| メモリ使用量上限 | Rustコンパイラに依存（数GB程度） |

## 排他制御

Cargoの内部ロック機構により、同一ターゲットに対する並列ビルドは自動的に排他制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | "Build native bindings" コマンド表示 |
| 進捗ログ | コンパイル中 | Cargoのコンパイル進捗（stdio: inherit） |
| 終了ログ | 型定義コピー時 | "Copy generated types to ..." |
| エラーログ | エラー発生時 | Cargoエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド時間 | 30分 | CI/CDパイプライン通知 |
| 終了コード | 0以外 | コンソール出力 |

## 備考

- エントリポイント: `scripts/build-native.ts`
- 実行コマンド: `pnpm swc-build-native`
- Cargoビルドは `shell: true` オプションで実行される（SIGINTの終了コード問題への対応）
- 型定義ファイルの統合では `// GENERATED-TYPES-BELOW` マーカーを使用してユーザー定義部分と自動生成部分を分離している
- `// DO NOT MANUALLY EDIT THESE TYPES` の注記が自動付与される
