# バッチ設計書 32-next-analyze

## 概要

本ドキュメントは、Next.jsのプロダクションビルドにおけるバンドル分析コマンド（next analyze）の設計について記載する。ビルド成果物のサイズや構成を分析するためのCLIコマンドである。

### 本バッチの処理概要

next analyzeコマンドは、Next.jsアプリケーションのプロダクションビルドを実行し、バンドルの分析結果を生成するCLIツールである。

**業務上の目的・背景**：Next.jsアプリケーションのパフォーマンス最適化において、バンドルサイズの把握と分析は重要な課題である。開発者がビルド成果物の構成を視覚的に確認し、不要な依存関係やサイズの大きいモジュールを特定できるようにすることで、アプリケーションの読み込み速度改善を支援する。本コマンドはその分析機能を提供する。

**バッチの実行タイミング**：開発者が手動でCLIから実行する。パフォーマンス分析やビルド最適化の検討時に随時使用される。

**主要な処理内容**：
1. CPUプロファイル収集の初期化（オプション）
2. プロジェクトディレクトリの検証
3. マングリング無効化の警告表示（オプション）
4. プロファイリング有効化の警告表示（オプション）
5. analyze関数を呼び出してビルドと分析を実行
6. シグナルハンドラ（SIGTERM/SIGINT）によるCPUプロファイル保存

**前後の処理との関連**：next build（No.1）と同様のビルド処理を基盤としており、追加でバンドル分析機能を提供する。analyze関数は`packages/next/src/build/analyze`モジュールに実装されている。

**影響範囲**：プロジェクトの`.next`ディレクトリにビルド成果物と分析レポートが出力される。読み取り専用の分析処理であり、ソースコードには影響を与えない。

## バッチ種別

分析処理 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CLIコマンド手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プロジェクトディレクトリ | 有効なNext.jsプロジェクトディレクトリが存在すること |
| Node.js | Node.jsランタイムが利用可能であること |
| 依存パッケージ | Next.jsおよびその依存パッケージがインストールされていること |

### 実行可否判定

指定されたプロジェクトディレクトリが存在しない場合、エラーメッセージを表示してプロセスを終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| directory | string | No | カレントディレクトリ | プロジェクトルートディレクトリ |
| experimentalAnalyze | boolean | No | undefined | 実験的分析機能の有効化 |
| profile | boolean | No | undefined | React本番プロファイリングの有効化 |
| mangling | boolean | No | true | 変数名マングリングの有効/無効 |
| port | number | No | - | 分析レポートサーバーのポート番号 |
| output | boolean | No | - | 出力の有効/無効 |
| experimentalAppOnly | boolean | No | undefined | App Routerのみを対象とする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Next.jsプロジェクト | ファイルシステム | ソースコード、設定ファイル、依存パッケージ |
| next.config.js | JavaScript/TypeScript | Next.js設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .nextディレクトリ | ファイルシステム | ビルド成果物と分析レポート |
| コンソール | テキスト | 警告メッセージや進捗情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ビルド成果物（.nextディレクトリ配下） |
| 出力先 | {プロジェクトルート}/.next/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. シグナルハンドラ登録
   └─ SIGTERM（exit 143）、SIGINT（exit 130）でCPUプロファイル保存
2. オプション解析
   └─ profile、mangling、experimentalAppOnly、output、portの取得
3. マングリング無効化警告
   └─ manglingがfalseの場合に警告メッセージを表示
4. プロファイリング警告
   └─ profileがtrueの場合に警告メッセージを表示
5. プロジェクトディレクトリ取得
   └─ getProjectDir()でディレクトリパスを解決
6. ディレクトリ存在確認
   └─ 存在しない場合はエラーメッセージを表示して終了
7. analyze関数実行
   └─ ビルドとバンドル分析を実行
```

### フローチャート

```mermaid
flowchart TD
    A[CLIコマンド実行] --> B[シグナルハンドラ登録]
    B --> C[オプション解析]
    C --> D{mangling無効?}
    D -->|Yes| E[警告表示]
    D -->|No| F{profile有効?}
    E --> F
    F -->|Yes| G[警告表示]
    F -->|No| H[プロジェクトディレクトリ取得]
    G --> H
    H --> I{ディレクトリ存在?}
    I -->|No| J[エラー終了]
    I -->|Yes| K[analyze関数実行]
    K --> L[分析完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ディレクトリ不在 | 指定ディレクトリが存在しない | 正しいプロジェクトディレクトリを指定 |
| EXIT_143 | シグナル終了 | SIGTERM受信 | CPUプロファイルを保存して終了 |
| EXIT_130 | シグナル終了 | SIGINT受信 | CPUプロファイルを保存して終了 |
| N/A | ビルドエラー | ソースコードのコンパイルエラー | ソースコードを修正して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ビルドエラーが発生した場合は、エラーメッセージに従いソースコードまたは設定を修正する。シグナルによる中断時はCPUプロファイルが保存される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクトのビルドと分析 |
| 目標処理時間 | プロジェクト規模に依存（通常数分〜数十分） |
| メモリ使用量上限 | Node.jsのデフォルトヒープサイズに依存 |

## 排他制御

同一プロジェクトに対する複数の同時実行は想定されていない。.nextディレクトリへの書き込みが競合する可能性があるため、排他的に実行すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | マングリング無効時 | "Mangling is disabled. Note: This may affect performance..." |
| 警告ログ | プロファイリング有効時 | "Profiling is enabled. Note: This may affect performance." |
| エラーログ | ディレクトリ不在時 | "> No such directory exists as the project root: {dir}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | CLIコマンドのため監視対象外 |

## 備考

- 本コマンドはCLIエントリポイント`packages/next/src/cli/next-analyze.ts`から実行される。
- 実際の分析ロジックは`packages/next/src/build/analyze`モジュールに委譲される。
- CPUプロファイル機能は`packages/next/src/server/lib/cpu-profile`モジュールで提供される。
- picocolorsライブラリを使用してコンソール出力のスタイリングを行う。
