# バッチ設計書 33-next-info

## 概要

本ドキュメントは、Next.jsプロジェクトの環境情報を収集・表示するCLIコマンド（next info）の設計について記載する。OS、Node.jsバージョン、パッケージバージョン等のシステム情報を収集し、イシュー報告やデバッグを支援する。

### 本バッチの処理概要

next infoコマンドは、Next.jsプロジェクトの実行環境に関する診断情報を収集し、標準出力に表示するユーティリティコマンドである。

**業務上の目的・背景**：Next.jsのバグ報告やトラブルシューティングにおいて、開発環境の情報（OS、Node.jsバージョン、依存パッケージバージョン等）が不可欠である。本コマンドは、これらの情報を一括で収集・表示することで、GitHub Issueへの環境情報の記載を容易にし、問題の迅速な解決を支援する。また`--verbose`モードでは、next-swcバイナリの依存関係確認やDLOPENエラーのデバッグに必要な詳細診断情報を提供する。

**バッチの実行タイミング**：開発者がバグ報告やトラブルシューティング時に手動でCLIから実行する。

**主要な処理内容**：
1. 基本モード：OS情報、バイナリバージョン、関連パッケージバージョン、Next.js設定の表示
2. npmレジストリから最新バージョン情報を取得し、バージョンの鮮度（staleness）を表示
3. verboseモード：Host情報（WSL/Docker/CI検出）、Node.js診断レポート、next-swcインストール状態確認、共有ライブラリ依存関係チェック
4. プラットフォーム別の診断ツール（ldd/otool/dumpbin.exe）を使用したnext-swc依存関係チェック

**前後の処理との関連**：独立したCLIコマンドであり、他のバッチとの直接的な依存関係はない。バグ報告時のワークフローの一部として使用される。

**影響範囲**：読み取り専用の診断コマンドであり、ファイルシステムやプロジェクト設定に変更を加えない。外部ネットワーク（npmレジストリ）へのアクセスを行う。

## バッチ種別

分析・診断 / 情報収集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CLIコマンド手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | Node.jsランタイムが利用可能であること |
| Next.jsプロジェクト | Next.jsがインストールされたプロジェクトディレクトリであること |
| ネットワーク接続 | npmレジストリへのアクセスが可能であること（オフラインでも動作するが一部情報が制限される） |

### 実行可否判定

特別な実行可否判定はない。Next.jsパッケージが見つからない場合は"N/A"と表示される。verboseモードでサポート外のプラットフォーム（win32/linux/darwin以外）の場合、メッセージを表示して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| verbose | boolean | No | false | 詳細診断モードの有効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| node_modules | ファイルシステム | 各パッケージのpackage.json |
| npmレジストリ | HTTP API | Next.jsのdist-tags情報 |
| OSシステム情報 | OS API | プラットフォーム、アーキテクチャ、メモリ等 |
| next.config | JavaScript/TypeScript | Next.js設定ファイル |
| システムツール | バイナリ | ldd/otool/dumpbin.exe（verboseモード） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 環境情報の構造化テキスト |

### 出力ファイル仕様

本コマンドはファイル出力を行わない。全情報は標準出力に表示される。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | stdout |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
■ 基本モード
1. パッケージバージョン取得
   └─ next, eslint-config-next, react, react-dom, typescriptのバージョン取得
2. Next.js設定読み込み
   └─ loadConfigでoutput設定等を取得
3. npmレジストリアクセス
   └─ dist-tagsから最新版情報を取得（失敗時は警告表示して継続）
4. バージョン鮮度判定
   └─ parseVersionInfoとgetStalenessで判定
5. OS情報収集
   └─ プラットフォーム、アーキテクチャ、メモリ、CPUコア数
6. バイナリバージョン取得
   └─ Node, npm, Yarn, pnpmの--versionを実行
7. 情報表示
   └─ 構造化テキストとして標準出力に表示
8. 古いバージョン警告
   └─ staleの場合にcanaryバージョンの試行を推奨

■ verboseモード（追加タスク）
1. Host情報
   └─ WSL/Docker/CI検出
2. Next.jsインストール情報
   └─ 基本モードと同等
3. Node.js診断レポート
   └─ process.report.getReport()でヒープ情報等を取得
4. next-swcインストール確認
   └─ loadBindingsでバインディングをロード、トリプル解決
5. next-swc共有ライブラリ依存チェック
   └─ プラットフォーム別ツール（linux:ldd, darwin:otool/dyld_info, win32:dumpbin.exe）
```

### フローチャート

```mermaid
flowchart TD
    A[CLIコマンド実行] --> B{verboseモード?}
    B -->|No| C[パッケージバージョン取得]
    C --> D[Next.js設定読み込み]
    D --> E[npmレジストリアクセス]
    E --> F[OS情報収集]
    F --> G[バイナリバージョン取得]
    G --> H[情報表示]
    H --> I[完了]
    B -->|Yes| J{プラットフォーム対応?}
    J -->|No| K[非対応メッセージ表示]
    J -->|Yes| L[診断タスク順次実行]
    L --> M[Host情報]
    M --> N[インストール情報]
    N --> O[Node.js診断レポート]
    O --> P[next-swcインストール確認]
    P --> Q[共有ライブラリ依存チェック]
    Q --> R[診断レポート表示]
    R --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | パッケージ未検出 | require(packageName)が失敗 | "N/A"を返して処理続行 |
| N/A | バイナリ未検出 | execFileSyncが失敗 | "N/A"を返して処理続行 |
| N/A | レジストリアクセス失敗 | npmレジストリへのfetchが失敗 | 警告メッセージを表示して処理続行 |
| N/A | 診断レポート未対応 | process.report.getReport()がnull | failステータスで記録 |
| N/A | 非対応プラットフォーム | win32/linux/darwin以外 | メッセージ表示して終了（verboseモード） |
| N/A | next-swc未検出 | require.resolveが失敗 | skippedステータスで記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（エラー発生箇所で個別にハンドリング） |

### 障害時対応

各診断タスクは独立しており、個別のエラーは他のタスクに影響しない。タスクごとにpass/fail/skippedのステータスが記録される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で環境情報を1セット収集 |
| 目標処理時間 | 基本モード: 数秒、verboseモード: 数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用の処理であるため、排他制御は不要。同時実行も問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 基本モード実行時 | OS情報、バイナリバージョン、パッケージバージョン |
| 警告ログ | レジストリアクセス失敗時 | "Failed to fetch latest canary version" |
| 警告ログ | 古いバージョン検出時 | バージョン更新推奨メッセージ |
| 診断ログ | verboseモード | 各タスクのpass/fail/skippedステータスと詳細出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | CLIコマンドのため監視対象外 |

## 備考

- 本コマンドはCLIエントリポイント`packages/next/src/cli/next-info.ts`から実行される。
- verboseモードでの診断レポートは、GitHub Issueに貼り付けることを想定した形式で出力される。
- NEXT_RSPACKの環境変数が設定されている場合、next-rspackのバージョンも表示される。
- 共有ライブラリ依存チェックはシステムツールに依存するため、ツール未インストール時はスキップされる。
- Node.js診断レポートからはセキュリティ上の配慮として、cwd、commandLine、host、cpus、networkInterfacesフィールドが削除される。
