# バッチ設計書 34-analyze-dev-server-bundle

## 概要

本ドキュメントは、Next.js開発サーバーバンドルのwebpack-bundle-analyzerレポート生成バッチ（analyze-dev-server-bundle）の設計について記載する。バンドル済み開発サーバーのモジュール構成と外部化モジュールを分析する。

### 本バッチの処理概要

analyze-dev-server-bundleは、Next.jsの開発サーバーバンドル（start-server.js）をビルドしながらバンドル分析レポートを生成するスクリプトである。

**業務上の目的・背景**：Next.jsの開発サーバーは起動速度の最適化のためにバンドルされている。バンドルサイズの増大はサーバー起動時間に直接影響するため、定期的にバンドル構成を分析し、不要なモジュールの混入やサイズの異常な増加を検出する必要がある。本スクリプトは、webpack-bundle-analyzerを使用したインタラクティブなツリーマップレポートの生成、バンドルモジュール一覧の出力、外部化モジュール一覧の出力を提供する。

**バッチの実行タイミング**：開発者がバンドルサイズの調査や最適化時に手動で実行する。

**主要な処理内容**：
1. ANALYZE=1環境変数付きでtaskrによる開発サーバーバンドルのビルド
2. ビルド成果物（start-server.js）のサイズ統計表示
3. バンドルされたモジュール一覧の抽出と表示（--list-modulesオプション）
4. 外部化されたモジュール一覧の抽出と表示（--list-externalsオプション）
5. stats.jsonの出力（--jsonオプション）
6. HTMLレポートのブラウザ表示（--openオプション）

**前後の処理との関連**：taskrビルドシステム（packages/next内のビルドタスク）と連携して動作する。バンドル対象は`dist/compiled/dev-server/start-server.js`である。

**影響範囲**：packages/next/dist/compiled/dev-server/配下にビルド成果物とレポートファイルが生成される。ソースコードには影響しない。

## バッチ種別

分析処理 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行（`node scripts/analyze-dev-server-bundle.js`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| packages/nextディレクトリ | Next.jsパッケージのソースが存在すること |
| taskr | ビルドツール（taskr/npx）が利用可能であること |
| Node.js | Node.jsランタイムが利用可能であること |

### 実行可否判定

ビルド失敗時はエラーメッセージを表示してexit code 1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --open | flag | No | false | HTMLレポートをブラウザで開く |
| --verbose | flag | No | false | 詳細なビルド出力を表示 |
| --json | flag | No | false | stats.jsonファイルも出力 |
| --list-modules | flag | No | false | バンドルモジュール一覧を表示 |
| --list-externals | flag | No | false | 外部化モジュール一覧を表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next/src | TypeScript/JavaScript | 開発サーバーのソースコード |
| taskrタスク定義 | JavaScript | next_bundle_dev_serverタスク |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| bundle-report.html | HTML | webpack-bundle-analyzerのツリーマップレポート |
| start-server.js | JavaScript | バンドル済み開発サーバー |
| stats.json | JSON | webpackビルド統計（--jsonオプション時） |
| 標準出力 | テキスト | サイズ統計、モジュール一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | bundle-report.html / start-server.js / stats.json |
| 出力先 | packages/next/dist/compiled/dev-server/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ --open, --verbose, --json, --list-modules, --list-externalsの判定
2. バンドルビルド実行
   └─ ANALYZE=1環境変数付きで`npx taskr next_bundle_dev_server`を実行
3. バンドルサイズ統計表示
   └─ start-server.jsのファイルサイズをKB/MB単位で表示
4. モジュール一覧抽出（オプション）
   └─ バンドルファイル内の"./dist/"パターンを正規表現で抽出
5. 外部化モジュール一覧抽出（オプション）
   └─ require("next/dist/...")やrequire("@next/...")パターンを抽出
6. stats.json出力パス表示（オプション）
   └─ --jsonフラグ時にstats.jsonのパスを表示
7. ブラウザでレポート表示（オプション）
   └─ プラットフォーム別コマンド（open/start/xdg-open）で表示
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[引数解析]
    B --> C[ANALYZE=1でバンドルビルド]
    C --> D{ビルド成功?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[サイズ統計表示]
    F --> G{--list-modules?}
    G -->|Yes| H[モジュール一覧抽出・表示]
    G -->|No| I{--list-externals?}
    H --> I
    I -->|Yes| J[外部化モジュール一覧表示]
    I -->|No| K{--json?}
    J --> K
    K -->|Yes| L[stats.jsonパス表示]
    K -->|No| M{--open?}
    L --> M
    M -->|Yes| N[ブラウザでレポート表示]
    M -->|No| O[完了]
    N --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EXIT_1 | ビルドエラー | taskrビルドが失敗 | ビルドエラーの内容を確認して修正 |
| N/A | ブラウザ起動失敗 | open/start/xdg-openが失敗 | 手動でHTMLファイルを開く |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ビルド失敗時はexit code 1で終了する。ブラウザ起動失敗時はレポートファイルのパスを表示して手動での確認を促す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルドと分析 |
| 目標処理時間 | 数分（webpackバンドルビルド時間に依存） |
| メモリ使用量上限 | webpackビルドに依存 |

## 排他制御

packages/next/dist/compiled/dev-server/への書き込みが競合する可能性があるため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ビルド開始時 | "Building bundle with analyzer..." |
| 情報ログ | ビルド完了時 | バンドルサイズ（KB/MB）、ファイルパス |
| 情報ログ | モジュール一覧表示時 | モジュールパス一覧とTotal数 |
| 情報ログ | 外部化一覧表示時 | 外部requireパス一覧とTotal数 |
| エラーログ | ビルド失敗時 | "Build failed" |
| 情報ログ | 完了時 | "Done!" とTips |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- 本スクリプトは`scripts/analyze-dev-server-bundle.js`に配置されている。
- モジュール一覧は`"./dist/"`パターンでバンドルファイル内を正規表現検索して抽出する。
- 外部化モジュール一覧は`require("next/dist/...")`、`require("@next/...")`、`require("styled-jsx...")`パターンで抽出する。
- verbose有効時は、ANALYZE_REASONS=1環境変数も設定され、詳細な依存理由が出力される。
- ブラウザ起動コマンドはプラットフォームに応じて自動選択される（darwin: open, win32: start, その他: xdg-open）。
