# バッチ設計書 35-trace-next-server

## 概要

本ドキュメントは、Next.jsサーバーのファイルトレースとバンドルサイズ測定バッチ（trace-next-server）の設計について記載する。NFT（Node File Trace）を使用してnext-serverの依存ファイルをトレースし、圧縮サイズの上限チェックを行う。

### 本バッチの処理概要

trace-next-serverは、プロダクション環境で使用されるNext.jsサーバー（next-server.js）の依存ファイルを@vercel/nftでトレースし、トレース結果のサイズを測定するスクリプトである。

**業務上の目的・背景**：Next.jsのプロダクションサーバーのデプロイサイズは、サーバーレス環境（Vercel等）でのコールドスタート時間に直接影響する。依存ファイルの総サイズが増大すると、デプロイパッケージのサイズが膨らみ、パフォーマンスが低下する。本バッチはnext-serverの依存ファイルをトレースし、gzip圧縮後のサイズが上限（250KB）以内であること、非圧縮サイズが上限（2.5MB）以内であることを検証する。これにより、サイズリグレッションを早期に検出する。

**バッチの実行タイミング**：CI/CDパイプラインまたは開発者の手動実行で随時実行される。

**主要な処理内容**：
1. モノレポ外のクリーンな一時ディレクトリにNext.jsをインストール
2. linkPackagesでモノレポのパッケージをリンク
3. nodeFileTraceでnext-server.jsの依存ファイルをトレース
4. トレースされた各ファイルのgzipサイズと非圧縮サイズを集計
5. トレース結果をnext-server.js.nft.jsonとして出力
6. サイズ上限チェック（圧縮250KB、非圧縮2.5MB）
7. 一時ディレクトリのクリーンアップ

**前後の処理との関連**：next build（No.1）で生成されるnext-server.jsを対象とする。next-stats-actionのlinkPackagesユーティリティを使用する。

**影響範囲**：`packages/next/dist/server/next-server.js.nft.json`にトレース結果が書き込まれる。一時ディレクトリの作成と削除が行われる。

## バッチ種別

分析処理 / サイズ検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/手動） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| モノレポ構造 | Next.jsモノレポのソースが存在すること |
| Node.js | Node.jsランタイムが利用可能であること |
| yarn | yarnパッケージマネージャーが利用可能であること |
| 依存パッケージ | execa, pretty-bytes, gzip-size, @vercel/nftがインストールされていること |

### 実行可否判定

特別な実行可否判定はない。依存パッケージが不足している場合はrequireエラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next | ファイルシステム | Next.jsパッケージのソースとビルド成果物 |
| next-stats-action | JavaScript | linkPackagesユーティリティ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| next-server.js.nft.json | JSON | トレースされた依存ファイル一覧 |
| 標準出力 | テキスト | ファイル数、圧縮/非圧縮サイズ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | next-server.js.nft.json |
| 出力先 | packages/next/dist/server/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（JSON形式） |

## 処理フロー

### 処理シーケンス

```
1. 一時ディレクトリ準備
   └─ os.tmpdir()に作業用ディレクトリとリポジトリコピー用ディレクトリを作成
2. リポジトリコピー
   └─ testディレクトリ、ドットファイル、node_modulesを除外してコピー
3. パッケージリンク
   └─ linkPackagesでモノレポパッケージのtarballパスを取得
4. 一時プロジェクト作成
   └─ package.jsonを生成してyarn installを実行
5. ファイルトレース
   └─ nodeFileTraceでnext-server.jsの依存を解析（除外パターンあり）
6. サイズ集計
   └─ 各トレースファイルのgzipサイズと非圧縮サイズを集計
7. 結果出力
   └─ ファイル数、圧縮/非圧縮サイズを表示
8. NFTファイル書き込み
   └─ next-server.js.nft.jsonにトレース結果を保存
9. クリーンアップ
   └─ 一時ディレクトリを削除
10. サイズ上限チェック
    └─ 圧縮250KB、非圧縮2.5MBを超過した場合はエラーをスロー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[一時ディレクトリ作成]
    B --> C[リポジトリコピー]
    C --> D[パッケージリンク]
    D --> E[yarn install]
    E --> F[nodeFileTraceでトレース]
    F --> G[各ファイルのサイズ集計]
    G --> H[結果表示]
    H --> I[NFTファイル書き込み]
    I --> J[一時ディレクトリ削除]
    J --> K{サイズ上限内?}
    K -->|Yes| L[正常終了]
    K -->|No| M[エラーをスロー]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | サイズ超過 | 圧縮サイズ > 250KB または 非圧縮サイズ > 2.5MB | 依存関係を見直してサイズを削減 |
| N/A | インストールエラー | yarn installが失敗 | ネットワーク接続やパッケージ整合性を確認 |
| N/A | トレースエラー | nodeFileTraceが失敗 | Next.jsビルド成果物の存在を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時はconsole.errorに出力される。一時ディレクトリは処理完了前にクリーンアップされる設計だが、異常終了時は手動での削除が必要な場合がある。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のトレースで数百〜数千ファイル |
| 目標処理時間 | 数分（パッケージインストールとトレースに依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

packages/next/dist/server/next-server.js.nft.jsonへの書き込みが競合する可能性があるため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 開始時 | "using workdir {path}" / "using repodir {path}" |
| タイマーログ | トレース前後 | console.time/timeEnd("traced {path}") |
| 情報ログ | 集計完了時 | numberFiles, totalGzipSize, totalUncompressedSize |
| 情報ログ | 正常終了時 | "done" |
| エラーログ | サイズ超過時 | "Max traced size of next-server exceeded limits..." |
| 情報ログ | トレース中 | "not a file"（ディレクトリの場合） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 圧縮サイズ | 250KB | スクリプト内のエラースロー |
| 非圧縮サイズ | 2.5MB | スクリプト内のエラースロー |

## 備考

- 本スクリプトは`scripts/trace-next-server.js`に配置されている。
- MAX_COMPRESSED_SIZE = 250,000バイト（約250KB）、MAX_UNCOMPRESSED_SIZE = 2,500,000バイト（約2.5MB）がハードコードされている。
- nodeFileTraceの除外パターンには、pages、image-optimizer、webpack、開発用Reactモジュール、sharpが含まれる。
- リポジトリコピー時にtestディレクトリ、ドットファイル（.で始まるファイル/ディレクトリ）、node_modulesが除外される。
- YARN_CACHE_FOLDERを一時ディレクトリ内に設定して、グローバルキャッシュへの影響を回避している。
