# バッチ設計書 36-benchmark-next-dev-boot

## 概要

本ドキュメントは、Next.js開発サーバーの起動時間ベンチマーク測定バッチ（benchmark-next-dev-boot）の設計について記載する。複数回の起動測定を行い、統計値（平均、中央値、最小、最大）を算出する。

### 本バッチの処理概要

benchmark-next-dev-bootは、Next.js開発サーバーの起動時間を反復測定し、パフォーマンス統計を生成するベンチマークスクリプトである。

**業務上の目的・背景**：Next.jsの開発サーバー起動時間は開発者体験に大きく影響する重要な指標である。特にバンドル済み開発サーバーと非バンドル版の起動時間比較は、バンドル最適化の効果検証に不可欠である。本バッチは、複数回の起動測定を行い統計的に信頼性のあるベンチマーク結果を提供する。Turbopack/Webpack両方のバンドラーでの測定をサポートする。

**バッチの実行タイミング**：パフォーマンス最適化の検討時や、開発サーバーに関する変更のリグレッション確認時に手動で実行する。

**主要な処理内容**：
1. テストプロジェクトディレクトリの存在確認
2. 既存のnext devプロセスの強制終了
3. .nextキャッシュディレクトリの削除
4. next devコマンドの起動と"Ready in Xms"パターンの検出
5. 報告時間（Next.js内部計測）と実時間（CLI起動から準備完了まで）の記録
6. 統計計算（平均、中央値、最小、最大）
7. バンドル版/非バンドル版の比較測定（--compareオプション）

**前後の処理との関連**：packages/next/dist/bin/nextのビルド済みバイナリを使用する。--compare時はpackages/next/src/cli/next-dev.tsのソースを書き換え、taskr cliで再ビルドを行う。

**影響範囲**：テストプロジェクトの.nextディレクトリの削除、--compare時はnext-dev.tsソースの一時的な変更とリビルドが行われる。

## バッチ種別

パフォーマンス測定 / ベンチマーク

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行（`node scripts/benchmark-next-dev-boot.js`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| テストプロジェクト | Next.jsプロジェクトが指定ディレクトリに存在すること |
| Next.jsビルド済み | packages/next/dist/bin/nextが存在すること |
| pkill | プロセス終了コマンドが利用可能であること |

### 実行可否判定

テストプロジェクトディレクトリが存在しない場合、プロジェクト作成手順を表示してexit code 1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --iterations=N | number | No | 5 | 測定回数 |
| --test-dir=PATH | string | No | /private/tmp/next-boot-test | テストプロジェクトディレクトリ |
| --bundled | flag | No | デフォルト | バンドル済み開発サーバーを使用 |
| --unbundled | flag | No | - | 非バンドル開発サーバーを使用 |
| --compare | flag | No | false | バンドル版/非バンドル版の比較実行 |
| --turbopack | flag | No | デフォルト | Turbopackを使用 |
| --webpack | flag | No | - | Webpackを使用 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストプロジェクト | ファイルシステム | Next.jsアプリケーションプロジェクト |
| packages/next/dist/bin/next | JavaScript | Next.jsのCLIバイナリ |
| packages/next/src/cli/next-dev.ts | TypeScript | --compare時に書き換え対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各イテレーションの測定結果と統計値 |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A |
| 出力先 | stdout |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ iterations, test-dir, compare, webpack等のオプション取得
2. テストディレクトリ存在確認
   └─ 存在しない場合はプロジェクト作成手順を表示して終了
3. 既存プロセス終了
   └─ `pkill -f "next dev"`で既存プロセスを停止
4. ベンチマーク実行（compare時はバンドル版→非バンドル版の順）
   └─ 4a. 各イテレーション:
       ├─ .nextディレクトリ削除
       ├─ next devプロセス起動（FORCE_COLOR=0）
       ├─ "Ready in Xms"パターン待機（60秒タイムアウト）
       ├─ 報告時間と実時間を記録
       └─ プロセス終了（SIGTERM）
   └─ 4b. 統計計算（平均、中央値、最小、最大）
5. 比較結果表示（--compare時）
   └─ バンドル版/非バンドル版の時間差を表示
6. ソース復元（--compare時）
   └─ バンドル版に戻してリビルド
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[引数解析]
    B --> C{テストディレクトリ存在?}
    C -->|No| D[手順表示・終了]
    C -->|Yes| E[既存プロセス終了]
    E --> F{compareモード?}
    F -->|No| G[ベンチマーク実行]
    F -->|Yes| H[バンドル版に切替・リビルド]
    H --> I[バンドル版ベンチマーク]
    I --> J[非バンドル版に切替・リビルド]
    J --> K[非バンドル版ベンチマーク]
    K --> L[バンドル版に復元]
    L --> M[比較結果表示]
    G --> N[結果表示]
    M --> N
    N --> O[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EXIT_1 | ディレクトリ不在 | テストディレクトリが存在しない | プロジェクトを作成 |
| N/A | タイムアウト | 60秒以内にサーバーが起動しない | サーバー起動エラーを確認 |
| N/A | プロセスエラー | next devプロセスが起動失敗 | Next.jsビルド状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（イテレーション内でのリトライはない） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（失敗したイテレーションは"Failed"と記録される） |

### 障害時対応

個々のイテレーション失敗は記録されるが、他のイテレーションには影響しない。全イテレーション失敗時は"No successful runs"と表示される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | デフォルト5イテレーション |
| 目標処理時間 | イテレーション数 x サーバー起動時間（通常数分） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

`pkill -f "next dev"`で既存プロセスを強制終了するため、他のnext devプロセスにも影響する。イテレーション間に500msの待機時間がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 開始時 | イテレーション数、テストディレクトリ、バンドラー名 |
| 情報ログ | 各イテレーション | "Run N: Xms (reported) / Yms (actual)" |
| 結果ログ | ベンチマーク完了時 | Avg/Min/Max/Median（reported/actual） |
| 比較ログ | compare完了時 | 時間差と速度比較結果 |
| エラーログ | イテレーション失敗時 | "Run N: Failed - {message}" |
| エラーログ | 全失敗時 | "No successful runs" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- 本スクリプトは`scripts/benchmark-next-dev-boot.js`に配置されている。
- "Ready in Xms"パターンでNext.jsの内部報告時間を、Date.now()差分で実際の起動時間を測定する。
- --compareオプション使用時は、next-dev.tsのstartServerPath変数を書き換えてtaskr cliで再ビルドを行うため、ソースコードに一時的な変更が加えられる。使用後はバンドル版に復元される。
- FORCE_COLOR=0環境変数を設定して、色付きエスケープシーケンスによるパターンマッチへの干渉を防止している。
- 各イテレーション前にpkillで既存プロセスを終了し、500ms待機後に次のイテレーションを開始する。
