# バッチ設計書 37-devlow-bench

## 概要

本ドキュメントは、@vercel/devlow-benchフレームワークを使用したNext.js開発サーバーのパフォーマンスベンチマークバッチ（devlow-bench）の設計について記載する。ブラウザセッション付きの包括的なパフォーマンス測定を行う。

### 本バッチの処理概要

devlow-benchは、@vercel/devlow-benchフレームワークを活用して、Next.jsの開発サーバー（dev）およびプロダクションビルド+起動（build+start）の包括的なパフォーマンスベンチマークを実行するスクリプトである。

**業務上の目的・背景**：Next.jsの開発者体験とプロダクションパフォーマンスの両方において、サーバー起動時間、ページ読み込み時間、HMR（Hot Module Replacement）のレイテンシは重要な指標である。本バッチは@vercel/devlow-benchフレームワークを使用して、実際のブラウザセッションを含むエンドツーエンドのパフォーマンス測定を自動化する。Turbopack/Webpack両方のモードでの比較測定、キャッシュ有無での比較、メモリ使用量の記録を統合的に実施する。

**バッチの実行タイミング**：CI/CDパイプラインでのパフォーマンスリグレッション検出、または開発者の手動実行で随時実行される。

**主要な処理内容**：
1. ベンチマークプロジェクト（bench/heavy-npm-deps）の.next削除によるクリーンアップ
2. ブラウザセッションの起動
3. 開発サーバーまたはビルド+サーバーの起動
4. サーバー起動時間の測定
5. ページナビゲーションと表示状態の検証
6. HMRテスト（ファイル変更→更新検出→レイテンシ測定、最大10回）
7. キャッシュ付き再起動でのパフォーマンス測定
8. メモリ使用量の記録
9. Gitコミットハッシュとブランチ情報の付与

**前後の処理との関連**：bench/heavy-npm-depsディレクトリのベンチマークプロジェクトに依存する。pnpmスクリプト（dev-turbopack、dev-webpack、build-turbopack等）経由でNext.jsを実行する。

**影響範囲**：ベンチマークプロジェクトの.nextディレクトリとHMRテスト用ファイルの一時的な変更。測定結果は@vercel/devlow-benchフレームワークのレポートシステムに出力される。

## バッチ種別

パフォーマンス測定 / ベンチマーク

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/手動） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI/CDパイプラインまたは手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ベンチマークプロジェクト | bench/heavy-npm-depsディレクトリが存在すること |
| @vercel/devlow-bench | devlow-benchフレームワークがインストールされていること |
| ブラウザ | ヘッドレスブラウザが利用可能であること |
| pnpm | pnpmパッケージマネージャーが利用可能であること |
| Git | Gitが利用可能であること（SHA/ブランチ取得用） |

### 実行可否判定

特別な実行可否判定はない。環境変数GITHUB_SHA/GITHUB_REF_NAMEが未設定の場合は、gitコマンドでローカル情報を取得する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_SHA | string（環境変数） | No | git rev-parse HEAD | Gitコミットハッシュ |
| GITHUB_REF_NAME | string（環境変数） | No | git rev-parse --abbrev-ref HEAD | Gitブランチ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| bench/heavy-npm-deps | ファイルシステム | ベンチマークプロジェクト |
| components/lodash.js | JavaScript | HMRテスト対象ファイル |
| pnpmスクリプト | package.json | dev-turbopack, dev-webpack, build-turbopack等 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| devlow-benchレポート | フレームワーク出力 | 測定結果（時間、メモリ、ステータス） |

### 出力ファイル仕様

本バッチの出力は@vercel/devlow-benchフレームワークのレポートシステムに委ねられる。

| 項目 | 内容 |
|-----|------|
| ファイル名 | フレームワーク管理 |
| 出力先 | フレームワーク管理 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
■ Dev Workflow
1. .nextディレクトリ削除（クリーンアップ）
2. ブラウザセッション起動
3. 開発サーバー起動（pnpm dev-turbopack/dev-webpack）
4. "Ready in Xms"と"Local: URL"パターン待機
5. サーバー起動時間測定
6. メモリ使用量記録（起動後）
7. ページナビゲーション
8. ページ状態検証（404チェック、エラーチェック）
9. ページリロード
10. HMRテスト（最大10回）
    ├─ ファイル変更（tsx:div挿入、css:プロパティ追加、mdx:テキスト追加）
    ├─ HMRイベント待機（60秒タイムアウト）
    ├─ レイテンシ測定
    └─ 最初の3回はウォームアップ（hmr/warmup）
11. キャッシュ待機（Webpack時はファイルシステムキャッシュ書き込み待ち）
12. サーバー・ブラウザ終了
13. 新しいブラウザ・サーバー起動（キャッシュ付き）
14. キャッシュ付きページ読み込み測定
15. シャットダウン

■ Build Workflow
1. .nextディレクトリ削除
2. ビルド実行（pnpm build-turbopack/build-webpack）
3. ビルド時間測定
4. ブラウザセッション起動
5. サーバー起動（pnpm start-turbopack/start-webpack）
6. ページナビゲーション・検証
7. ページリロード
8. サーバー・ブラウザ終了
9. キャッシュ付きビルド実行・時間測定
10. キャッシュ付きサーバー起動・ページ読み込み測定
11. シャットダウン
```

### フローチャート

```mermaid
flowchart TD
    A[ベンチマーク開始] --> B[.next削除]
    B --> C[ブラウザセッション起動]
    C --> D{devモード?}
    D -->|Yes| E[dev server起動]
    D -->|No| F[ビルド実行]
    E --> G[サーバー起動時間測定]
    F --> H[ビルド時間測定]
    H --> I[サーバー起動]
    G --> J[ページナビゲーション]
    I --> J
    J --> K[ページ状態検証]
    K --> L{HMRテスト?}
    L -->|Yes| M[HMRサイクル x10]
    L -->|No| N[サーバー・ブラウザ終了]
    M --> N
    N --> O[キャッシュ付き再起動]
    O --> P[キャッシュ付きページ読み込み]
    P --> Q[シャットダウン・完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | HMRタイムアウト | 60秒以内にHMRが完了しない | HMRイベントハンドリングを確認 |
| N/A | ページ404 | ナビゲーション先ページが404 | ベンチマークプロジェクトの構成確認 |
| N/A | サーバー起動失敗 | Next.jsサーバーが起動しない | ビルド状態・設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | .next削除にretry関数（100ms〜2000ms間隔） |
| リトライ間隔 | 100ms刻みで最大2000msまで |
| リトライ対象エラー | .nextディレクトリ削除の失敗 |

### 障害時対応

finally句でクリーンアップタスクが逆順で実行される（シェルプロセス終了、ブラウザセッション終了、ファイル復元）。HMR失敗時はステータスコードで記録される（0:成功、1:リロード、2:タイムアウト、3:クリーンアップ中の失敗）。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | N/A |
| ロールバック条件 | finally句でのクリーンアップ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 3つのベンチマークシナリオ（dev、build、build-turbo-cache） |
| 目標処理時間 | シナリオごとに数分〜十数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

ポート番号は0（ランダムポート）を使用するため、ポート競合は回避される。同一ベンチマークプロジェクトの.nextディレクトリへのアクセスが競合するため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 測定ログ | 各フェーズ完了時 | measureTime（cleanup、build、server startup、hmr等） |
| 測定ログ | メモリ記録時 | reportMemUsage（起動後、ページ読み込み後） |
| 測定ログ | ステータス記録時 | reportMeasurement（page status、console output等） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | devlow-benchフレームワークのレポートシステム |

## 備考

- 本スクリプトは`scripts/devlow-bench.mjs`に配置されている（ESモジュール形式）。
- 3つのベンチマークシナリオが定義されている：heavy-npm-deps-dev（開発モード）、heavy-npm-deps-build（ビルドモード）、heavy-npm-deps-build-turbo-cache-enabled（Turboキャッシュ付きビルドモード）。
- HMRテストではファイル形式に応じた変更を行う：tsx(div挿入)、css(プロパティ追加)、mdx(テキスト追加)。
- HMRの最初の3回はウォームアップとして"hmr/warmup"名で記録され、4回目以降が"hmr"として記録される。
- __NEXT_TEST_MODE=1環境変数でHMRイベントの検出とcanaryチェックの抑制を行う。
- OTEL_SDK_DISABLED=trueでOpenTelemetry初期化を無効化し、ペンディングリクエストを防止する。
- Webpack時はファイルシステムキャッシュの書き込み完了を5秒間待機する（.next/dev/cache/webpack/client-development/index.pack）。
- PORT=0でランダムポートを使用し、URLを正規表現で抽出する。
- Git SHA/ブランチ情報が全測定結果のpropsに付与される。
