# バッチ設計書 38-pr-status

## 概要

本ドキュメントは、GitHub PRのCI実行状況・失敗ジョブログ・レビューコメントを取得し、分析レポートをMarkdownで生成するバッチ（pr-status）の設計について記載する。

### 本バッチの処理概要

pr-statusは、GitHub PRに関連するCI/CDワークフローの実行状況を取得し、失敗ジョブの詳細ログ、テスト結果、PRレビューコメントを収集して、構造化されたMarkdownレポートとして出力するスクリプトである。

**業務上の目的・背景**：Next.jsの開発においてCIの失敗分析やPRレビューコメントの確認は頻繁に行われる作業である。GitHub UIでの確認は画面遷移が多く効率が悪い。本バッチは、PR関連の情報を一括で収集し、ローカルファイルとして構造化されたMarkdownレポートを生成することで、CI失敗の原因分析とPRレビューの効率化を実現する。AIエージェント（Claude Code等）からの利用も想定している。

**バッチの実行タイミング**：開発者がCI失敗の分析やPRレビュー確認時に手動で実行する。

**主要な処理内容**：
1. ブランチ情報・PR番号の検出（引数指定またはgitコマンドによる自動検出）
2. GitHub Actions APIからワークフロー実行情報の取得
3. 失敗ジョブの特定とログの取得
4. ログからテスト結果JSON、テストケースグループ、セクション情報の抽出
5. PRレビュー、レビュースレッド（GraphQL）、一般コメントの取得
6. インデックスファイル、ジョブ詳細ファイル、テスト結果ファイル、レビューファイル等の生成
7. 進行中のCI実行にも対応（全ジョブステータスの表示）

**前後の処理との関連**：独立したCLIスクリプトとして動作する。gh CLIコマンドとGitHub APIに依存する。

**影響範囲**：scripts/pr-status/ディレクトリにMarkdownファイルとテキストファイルが生成される。既存の出力ディレクトリは実行時に削除・再作成される。

## バッチ種別

レポート生成 / 分析・診断

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行（`node scripts/pr-status.js [PR番号]`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| gh CLI | GitHub CLIがインストール・認証済みであること |
| Git | Gitリポジトリ内で実行すること（自動検出時） |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

ワークフロー実行が見つからない場合は"No workflow runs found"と表示して正常終了（exit 0）する。PR番号引数指定時にPRが見つからない場合はexit(1)で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PR番号 | number（CLIの第1引数） | No | 自動検出 | 対象PRの番号。省略時はカレントブランチから自動検出 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Actions API | REST API | ワークフロー実行、ジョブ、ログの取得 |
| GitHub Pull Requests API | REST API | PRレビュー、コメントの取得 |
| GitHub GraphQL API | GraphQL | レビュースレッド（インラインコメント）の取得 |
| Git | コマンドライン | ブランチ名の自動検出 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| index.md | Markdown | CI状況サマリー、失敗ジョブ一覧、PRレビュー一覧 |
| job-{id}.md | Markdown | 失敗ジョブの詳細（テスト結果、セクション一覧） |
| job-{id}-section-{n}.txt | テキスト | ジョブログのセクション（タイムスタンプ除去済み） |
| job-{id}-test-{name}.md | Markdown | 個別テストの出力と結果JSON |
| review-{id}.md | Markdown | PRレビューコメント |
| thread-{n}.md | Markdown | インラインレビュースレッド（diff hunk付き） |
| comment-{id}.md | Markdown | 一般コメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 上記の各ファイル |
| 出力先 | scripts/pr-status/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（Markdown形式） |

## 処理フロー

### 処理シーケンス

```
1. 出力ディレクトリ初期化
   └─ scripts/pr-status/を削除して再作成
2. ブランチ情報取得
   └─ PR番号引数 or gh pr viewで自動検出 or git rev-parseでブランチ名取得
3. ワークフロー実行取得
   └─ GitHub Actions APIからbuild-and-testワークフローの実行一覧を取得（最大10件）
4. 最新実行のメタデータ取得
   └─ 実行ID、ステータス、結論、SHA、URL等
5. ジョブ取得（実行状態に応じて分岐）
   └─ 進行中: 全ジョブ取得→カテゴリ分類
   └─ 完了済み: 失敗ジョブのみ取得（効率化）
6. PRレビューデータ取得（PR番号がある場合）
   └─ レビュー一覧、レビュースレッド（GraphQL）、一般コメント
   └─ ボットコメントをフィルタリング
7. 失敗ジョブ詳細処理
   ├─ ジョブメタデータ取得
   ├─ ジョブログ取得（50MBバッファ）
   ├─ テスト結果JSON抽出（--test output start/end--パターン）
   ├─ テストケースグループ抽出（##[group]パターン、リトライ統合）
   ├─ セクション抽出（##[group]/##[endgroup]境界）
   ├─ セクションファイル書き込み
   ├─ テストファイル書き込み
   └─ ジョブMarkdown生成・書き込み
8. レビューファイル書き込み
   └─ review-{id}.md、thread-{n}.md、comment-{id}.mdの生成
9. インデックスファイル生成
   └─ 全情報を集約したindex.mdを生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[出力ディレクトリ初期化]
    B --> C[ブランチ情報取得]
    C --> D[ワークフロー実行取得]
    D --> E{実行あり?}
    E -->|No| F[メッセージ表示・終了]
    E -->|Yes| G[メタデータ取得]
    G --> H{進行中?}
    H -->|Yes| I[全ジョブ取得・分類]
    H -->|No| J[失敗ジョブ取得]
    I --> K{PR番号あり?}
    J --> K
    K -->|Yes| L[レビューデータ取得]
    K -->|No| M{失敗ジョブあり?}
    L --> M
    M -->|No| N[レビューファイル書き込み]
    M -->|Yes| O[失敗ジョブ詳細処理]
    O --> P[ログ取得・解析]
    P --> Q[テスト結果抽出]
    Q --> R[ファイル書き込み]
    R --> N
    N --> S[index.md生成]
    S --> T[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EXIT_1 | PR取得失敗 | 引数指定のPR番号が見つからない | PR番号を確認して再実行 |
| EXIT_1 | 異常終了 | main()で未ハンドルの例外発生 | エラーログを確認 |
| N/A | ログ取得失敗 | ジョブログAPIが失敗 | "Logs not available"と記録して続行 |
| N/A | レビュー取得失敗 | PRレビューAPIが失敗 | 空配列を返して続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

個別のAPI呼び出し失敗はtry-catchで処理され、空配列や"Logs not available"を返して処理を継続する。致命的なエラーはmain()のcatchブロックでexit(1)となる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1PRの最新CI実行（失敗ジョブ数に依存） |
| 目標処理時間 | 数十秒〜数分（APIレスポンス時間に依存） |
| メモリ使用量上限 | 50MB（execSyncのmaxBuffer） |

## 排他制御

scripts/pr-status/ディレクトリの削除・再作成を行うため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各フェーズ | "Cleaning output directory..." / "Getting branch info..." 等 |
| 情報ログ | ブランチ検出時 | "Branch: {name}, PR: {number}" |
| 情報ログ | 実行検出時 | "Latest run: {id} ({status}/{conclusion})" |
| 情報ログ | ジョブ処理時 | "Processing failed job {id}: {name}..." |
| 情報ログ | 完了時 | "Done! Output written to {path}/index.md" |
| エラーログ | コマンド失敗時 | "Command failed: {cmd}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- 本スクリプトは`scripts/pr-status.js`に配置されている。
- ワークフロー名"build-and-test"のみを対象としている。
- ジョブログのタイムスタンプ（GitHub Actionsの"yyyy-mm-ddTHH:MM:SS.nnnZ"形式）は自動的に除去される。
- テスト結果JSONは`--test output start--`と`--test output end--`マーカーで囲まれたブロックから抽出される。
- テストケースグループは`##[group]`と`##[endgroup]`マーカーで区切られ、同一テストパスのリトライは統合される。
- ボットアカウント（ユーザー名が"-bot"または"[bot]"で終わる）のレビューやコメントはフィルタリングされる。
- 進行中のCI実行では全ジョブを取得して状態別（failed/in_progress/queued/succeeded/cancelled/skipped）に分類する。完了済みの実行では効率化のため失敗ジョブのみ取得する。
- ジョブログのmaxBufferは50MBに設定されている。
- ファイル名のサニタイズでは100文字以内に切り詰められる。
- GraphQL APIを使用してインラインレビュースレッド（diff hunk付き）を取得する。
