# バッチ設計書 39-next-typegen

## 概要

本ドキュメントは、Next.jsのTypeScript型定義自動生成CLIコマンド（next typegen）の設計について記載する。App Routerのルーティング情報からRoute型マニフェストやバリデータファイルを生成する。

### 本バッチの処理概要

next typegenコマンドは、Next.jsプロジェクトのファイルシステムルーティング構造を解析し、TypeScriptの型定義ファイル（route-types.d.ts、validator.ts、cache-life.d.ts、routes.d.ts）を自動生成するCLIツールである。

**業務上の目的・背景**：Next.jsのApp Routerでは、ルーティングがファイルシステムベースで定義される。開発者がリンクやリダイレクトで使用するルートパスが型安全であることは、ランタイムエラーの防止に重要である。本コマンドは、pages/とapp/ディレクトリのファイル構造を解析してRoute型マニフェストを生成し、strictRouteTypesオプション有効時に静的な型チェックによるルートパスの検証を可能にする。

**バッチの実行タイミング**：開発者がルート構造の変更後に手動でCLIから実行する。開発サーバー起動時に自動実行される場合もある。

**主要な処理内容**：
1. プロジェクトディレクトリの検証
2. Next.js設定（next.config）の読み込み
3. SWCバインディングのインストール
4. TypeScript設定の検証
5. Pages Router（pages/）のルート収集と処理
6. App Router（app/）のルート・レイアウト・デフォルトファイルの収集と処理
7. スロット情報の抽出と統合
8. Route型マニフェストの作成と書き込み
9. バリデータファイルの書き込み
10. cache-life型定義の生成
11. エントリファイル（routes.d.ts）の書き込み

**前後の処理との関連**：next build（No.1）の処理でも同様の型生成が行われる。本コマンドはビルドを実行せずに型定義のみを生成する独立したCLIコマンドである。

**影響範囲**：{distDir}/types/ディレクトリにroute-types.d.ts、validator.ts、cache-life.d.tsが生成される。{distDirRoot}/types/にroutes.d.ts（エントリファイル）が生成される。

## バッチ種別

コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CLIコマンド手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プロジェクトディレクトリ | 有効なNext.jsプロジェクトが存在すること |
| TypeScript | TypeScriptが設定済みであること |
| Node.js | Node.jsランタイムが利用可能であること |
| SWCバインディング | next-swcバインディングがインストール可能であること |

### 実行可否判定

プロジェクトディレクトリが存在しない場合、printAndExitで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| directory | string | No | カレントディレクトリ | プロジェクトルートディレクトリ |
| dir | string | No | undefined | NextTypegenOptionsのdir（未使用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pages/ディレクトリ | ファイルシステム | Pages Routerのページファイル |
| app/ディレクトリ | ファイルシステム | App Routerのページ、レイアウト、デフォルトファイル |
| next.config | JavaScript/TypeScript | Next.js設定（distDir、pageExtensions、experimental等） |
| tsconfig.json | JSON | TypeScript設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| route-types.d.ts | TypeScript型定義 | ルート型マニフェスト |
| validator.ts | TypeScript | ルートバリデータ |
| cache-life.d.ts | TypeScript型定義 | cacheLife設定の型定義 |
| routes.d.ts | TypeScript型定義 | エントリファイル（型参照のハブ） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | route-types.d.ts / validator.ts / cache-life.d.ts / routes.d.ts |
| 出力先 | {distDir}/types/ および {distDirRoot}/types/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（TypeScript形式） |

## 処理フロー

### 処理シーケンス

```
1. プロジェクトディレクトリ取得・検証
   └─ getProjectDirでパス解決、existsSyncで存在確認
2. Next.js設定読み込み
   └─ loadConfig(PHASE_PRODUCTION_BUILD)で設定取得
3. SWCバインディングインストール
   └─ installBindings(useWasmBinary)
4. ディレクトリ構造検出
   └─ findPagesDirでpagesDir/appDirの有無を判定
5. TypeScript設定検証
   └─ verifyTypeScriptSetupで設定の整合性確認
6. 出力ディレクトリ作成
   └─ {distDir}/types/をmkdir(recursive: true)
7. Pages Routerルート収集（pagesDirが存在する場合）
   └─ collectPagesFiles → createPagesMapping → processPageRoutes
8. App Routerルート収集（appDirが存在する場合）
   └─ collectAppFiles → createPagesMapping → processAppRoutes
   └─ extractSlotsFromAppRoutes + extractSlotsFromDefaultFiles → combineSlots
   └─ processLayoutRoutes
9. Route型マニフェスト作成
   └─ createRouteTypesManifest（全ルート情報 + redirects/rewrites設定）
10. ファイル書き込み
    └─ writeRouteTypesManifest → writeValidatorFile → writeCacheLifeTypes → writeRouteTypesEntryFile
```

### フローチャート

```mermaid
flowchart TD
    A[CLIコマンド実行] --> B[プロジェクトディレクトリ検証]
    B --> C{ディレクトリ存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[Next.js設定読み込み]
    E --> F[SWCバインディングインストール]
    F --> G[pages/app ディレクトリ検出]
    G --> H[TypeScript設定検証]
    H --> I[出力ディレクトリ作成]
    I --> J{pagesDir存在?}
    J -->|Yes| K[Pages Routerルート収集]
    J -->|No| L{appDir存在?}
    K --> L
    L -->|Yes| M[App Routerルート収集]
    L -->|No| N[Route型マニフェスト作成]
    M --> N
    N --> O[route-types.d.ts書き込み]
    O --> P[validator.ts書き込み]
    P --> Q[cache-life.d.ts書き込み]
    Q --> R[routes.d.ts書き込み]
    R --> S[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ディレクトリ不在 | プロジェクトディレクトリが存在しない | 正しいディレクトリを指定 |
| N/A | TypeScript設定エラー | tsconfig.jsonの設定に問題がある | TypeScript設定を修正 |
| N/A | SWCインストール失敗 | SWCバインディングがインストールできない | プラットフォーム互換性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラー発生時はプロセスが終了する。出力ファイルが部分的に生成された場合は、再実行で上書きされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクトのルート型生成 |
| 目標処理時間 | 数秒（プロジェクト規模に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

{distDir}/types/ディレクトリへの書き込みが競合する可能性があるため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 処理開始時 | "Generating route types..." |
| 情報ログ | 処理完了時 | "Types generated successfully" |
| エラーログ | ディレクトリ不在時 | "> No such directory exists as the project root: {dir}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | CLIコマンドのため監視対象外 |

## 備考

- 本コマンドはCLIエントリポイント`packages/next/src/cli/next-typegen.ts`から実行される。
- PHASE_PRODUCTION_BUILDフェーズでNext.js設定を読み込む。
- strictRouteTypesオプション（experimental.strictRouteTypes）が有効な場合、厳密なルート型チェックが行われる。
- srcディレクトリ構成（src/pages、src/app）を自動検出してisSrcDirフラグを設定する。
- App Routerのスロット情報は、ページファイルとデフォルトファイルの両方から抽出され、combineSlots関数で統合される。
- routes.d.tsエントリファイルは{distDirRoot}/types/に配置され、next-env.d.tsからの一貫したimportパスを提供する。
- redirectsとrewritesの設定もRoute型マニフェストに含まれる。
- cacheLife設定が存在する場合、cache-life.d.tsも生成される。
