# バッチ設計書 4-pack-next

## 概要

本ドキュメントは、Next.jsパッケージを外部プロジェクトテスト用にtarball形式でパッケージングする `pack-next` バッチの設計書である。JavaScriptビルドとネイティブバイナリの圧縮オプションを提供する。

### 本バッチの処理概要

`pack-next` は、Next.jsモノレポ内の主要パッケージ（next、next-swc、next-mdx、next-env、next-bundle-analyzer）をtarballまたはディレクトリ参照形式でパッケージングし、外部プロジェクトでのテスト利用を可能にするバッチ処理である。

**業務上の目的・背景**：Next.jsの開発中に、未リリースのビルド成果物を外部プロジェクトでテストする必要がある。npm publishせずにローカルのビルド成果物を外部プロジェクトから参照可能にすることで、リリース前の統合テストを実現する。特にCI環境ではtarball形式が必要であり、ネイティブバイナリのサイズ（2GiB超）への対応として圧縮オプションも提供する。

**バッチの実行タイミング**：随時実行。開発中のNext.jsを外部プロジェクトでテストする際に手動で実行する。

**主要な処理内容**：
1. JavaScriptビルドの実行（オプションでスキップ可能）
2. SWCネイティブバイナリのビルド
3. tarball形式でのパッケージング（オプション）
4. ネイティブバイナリの圧縮（strip/objcopy-zlib/objcopy-zstd）
5. 外部プロジェクトのpackage.jsonパッチ（--project指定時）
6. pnpm overrides設定の出力

**前後の処理との関連**：`pnpm install` が完了していること。`swc-build-native` が内部で呼び出される。外部プロジェクトでのテスト実行が後続処理となる。

**影響範囲**：`tarballs/` ディレクトリ（tarball出力時）、外部プロジェクトの `package.json`（--project指定時）。

## バッチ種別

パッケージング処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（`pnpm pack-next`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js, tsx, pnpm が利用可能であること |
| Rust/Cargo | SWCネイティブバイナリのビルドに必要 |
| 依存関係インストール済み | `pnpm install` が完了していること |

### 実行可否判定

yargsによるCLIオプション検証が行われる。`--compress` は `--tar` と組み合わせた場合のみ有効。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --js-build | boolean | No | true | JavaScriptビルドを実行するか（--no-js-buildでスキップ） |
| --project / -p | string | No | なし | パッチ対象の外部プロジェクトパス |
| --tar | boolean | No | false | tarball形式で出力 |
| --compress | string | No | Linux: "strip", 他: "none" | バイナリ圧縮方法（none/strip/objcopy-zlib/objcopy-zstd） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next/ | ディレクトリ | Next.jsパッケージのビルド成果物 |
| packages/next-swc/ | ディレクトリ | SWCネイティブバイナリ |
| packages/next-mdx/ | ディレクトリ | Next.js MDXパッケージ |
| packages/next-env/ | ディレクトリ | Next.js 環境変数パッケージ |
| packages/next-bundle-analyzer/ | ディレクトリ | バンドルアナライザーパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| tarballs/next.tar | tarball | Next.jsパッケージのtarball |
| tarballs/next-swc.tar | tarball | SWCネイティブバイナリのtarball |
| tarballs/next-mdx.tar | tarball | MDXパッケージのtarball |
| tarballs/next-env.tar | tarball | 環境変数パッケージのtarball |
| tarballs/next-bundle-analyzer.tar | tarball | バンドルアナライザーのtarball |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {パッケージ名}.tar |
| 出力先 | {NEXT_DIR}/tarballs/ |
| 文字コード | バイナリ（tar形式） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. CLIオプション解析
   └─ yargs によるオプション検証
2. JavaScriptビルド（--js-build有効時）
   └─ pnpm i && pnpm run build
3. 既存バイナリ削除（--tar && compress !== "strip" 時）
   └─ napi-rsの再書き込みのため既存バイナリを削除
4. SWCネイティブバイナリビルド
   └─ buildNative() 関数の呼び出し
5. tarball生成（--tar有効時）
   └─ 各パッケージを並列でtar化
   └─ next-swcは圧縮オプションに応じたstrip/objcopy処理
6. 外部プロジェクトパッチ / overrides出力
   └─ --project指定時: package.jsonを自動パッチ
   └─ 未指定時: pnpm overrides設定をコンソール出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: pack-next] --> B{--js-build?}
    B -->|Yes| C[pnpm install && build]
    B -->|No| D[スキップ]
    C --> E[SWCネイティブバイナリビルド]
    D --> E
    E --> F{--tar?}
    F -->|Yes| G[tarballs ディレクトリ作成]
    G --> H[各パッケージをtar化（並列）]
    H --> I[next-swcの圧縮処理]
    F -->|No| J[ディレクトリ参照モード]
    I --> K{--project指定?}
    J --> K
    K -->|Yes| L[外部プロジェクトpackage.jsonパッチ]
    K -->|No| M[pnpm overrides設定を出力]
    L --> N[バッチ終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| COMPRESS_TAR_CONFLICT | バリデーションエラー | --compress を --tar なしで使用 | --tar フラグを追加 |
| NATIVE_BUILD_FAILED | ビルドエラー | SWCネイティブバイナリのビルド失敗 | Rustコードを確認 |
| TAR_FAILED | パッケージングエラー | tarball生成失敗 | ディスク容量を確認 |
| ERR_FS_FILE_TOO_LARGE | ファイルサイズエラー | tarball が 2GiB超 | --compress strip を使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ビルド失敗時はエラーメッセージを確認し、原因に応じて対処する。ディスク容量不足の場合は不要なファイルを削除する。バイナリサイズが大きすぎる場合は `--compress strip` オプションを使用する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作のみ |
| コミットタイミング | 各tarball生成完了時 |
| ロールバック条件 | なし（途中失敗時は不完全な成果物が残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 5パッケージ |
| 目標処理時間 | ビルド含む: 数分～十数分、パッケージングのみ: 数十秒 |
| メモリ使用量上限 | Rustビルドに依存（数GB程度） |

## 排他制御

同一ディレクトリへの並列パッケージングは並列実行される（Promise.all）。ただし同一バッチの複数同時実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各処理ステップ | コマンド名と引数 |
| 進捗ログ | パッケージング中 | Pack {パッケージ名} |
| 終了ログ | 完了時 | pnpm overrides設定またはパッチ結果 |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分 | コンソール出力 |
| 終了コード | 0以外（process.exit(1)） | コンソール出力 |

## 備考

- エントリポイント: `scripts/pack-next.ts`（tsxで実行）
- 実行コマンド: `pnpm pack-next`
- tarball作成時に macOS では `--no-mac-metadata` オプションが自動付与される
- Linux環境ではデフォルトで `strip` 圧縮が適用される（pnmの2GiB制限対応）
- `npm pack` / `pnpm pack` ではなく `tar` コマンドを直接使用している理由: npm packはネイティブモジュール非対応、pnpm packはtargetディレクトリの圧縮に時間がかかるため
