# バッチ設計書 40-next-upgrade

## 概要

本ドキュメントは、Next.jsのアップグレードを実行するCLIコマンド（next upgrade）の設計について記載する。@next/codemod経由でコードモッドの適用を含むアップグレード処理を行う。

### 本バッチの処理概要

next upgradeコマンドは、Next.jsのバージョンアップグレードを実行するCLIツールである。@next/codemod@canaryパッケージのupgradeコマンドを子プロセスとして起動し、コードの自動変換（コードモッド）を含むアップグレード処理を委譲する。

**業務上の目的・背景**：Next.jsのメジャーバージョンアップグレード時には、破壊的変更に対応するためのコード修正が必要となる場合がある。手動でのコード修正は作業量が多く、修正漏れも発生しやすい。本コマンドは、@next/codemodパッケージが提供するコード自動変換機能を活用して、Next.jsのアップグレードに必要なコード変更を自動的に適用する。パッケージマネージャー（npm/yarn/pnpm）を自動検出してnpxに相当するコマンドを構築する。

**バッチの実行タイミング**：Next.jsの新バージョンリリース後に、開発者がプロジェクトのアップグレード時に手動で実行する。

**主要な処理内容**：
1. プロジェクトディレクトリの解決
2. パッケージマネージャーの検出（npm/yarn/pnpm）
3. npx相当コマンドの構築
4. @next/codemod@canaryのupgradeコマンドを子プロセスとして起動
5. プロセスの終了コードの伝搬

**前後の処理との関連**：@next/codemodパッケージ（外部パッケージ）に処理を委譲する。本コマンドはランチャーとしての役割を果たし、実際のアップグレードロジックは@next/codemod側に実装されている。

**影響範囲**：プロジェクトのソースコード、package.json、ロックファイル等に変更が加えられる（@next/codemodが実行するコードモッドの内容に依存）。

## バッチ種別

ユーティリティ / コード変換

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CLIコマンド手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プロジェクトディレクトリ | 有効なNext.jsプロジェクトが存在すること |
| Node.js | Node.jsランタイムが利用可能であること |
| パッケージマネージャー | npm、yarn、またはpnpmがインストールされていること |
| ネットワーク接続 | @next/codemod@canaryをダウンロードするためのネットワーク接続 |

### 実行可否判定

特別な実行可否判定はない。パッケージマネージャーの検出に失敗した場合はnpmがデフォルトで使用される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| directory | string | No | カレントディレクトリ | プロジェクトルートディレクトリ |
| revision | string | Yes | - | アップグレード先のバージョン/リビジョン |
| verbose | boolean | No | false | 詳細ログの有効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Next.jsプロジェクト | ファイルシステム | 現在のプロジェクト構成 |
| @next/codemod@canary | npm | 最新のコードモッドパッケージ |
| パッケージマネージャー設定 | ファイルシステム | yarn.lock/pnpm-lock.yaml/package-lock.json |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| プロジェクトソースコード | ファイルシステム | コードモッドにより変更されたソースファイル |
| 標準出力 | テキスト | @next/codemodの実行ログ |

### 出力ファイル仕様

出力内容は@next/codemodの実行結果に依存する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | @next/codemodの変換対象に依存 |
| 出力先 | プロジェクトルート配下 |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. プロジェクトディレクトリ解決
   └─ getProjectDir(directory)で絶対パスを取得
2. パッケージマネージャー検出
   └─ getNpxCommand(baseDir)でnpx相当コマンドを取得
      ├─ pnpm → "pnpm --silent dlx"
      ├─ yarn (dlx対応) → "yarn --quiet dlx"
      └─ npm → "npx --yes"
3. コマンド引数構築
   └─ [@next/codemod@canary, upgrade, {revision}] + (verbose ? [--verbose] : [])
4. 子プロセス起動
   └─ spawn(command, args, {stdio: 'inherit', cwd: baseDir})
5. 終了コード伝搬
   └─ process.exitCode = code ?? 0
```

### フローチャート

```mermaid
flowchart TD
    A[CLIコマンド実行] --> B[プロジェクトディレクトリ解決]
    B --> C[パッケージマネージャー検出]
    C --> D[npxコマンド構築]
    D --> E[@next/codemod@canary upgrade 実行]
    E --> F[子プロセス完了待機]
    F --> G[終了コード伝搬]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | npxコマンド失敗 | @next/codemodのダウンロードやインストール失敗 | ネットワーク接続を確認して再実行 |
| N/A | コードモッド失敗 | @next/codemodの実行中にエラー | エラーメッセージに従い手動でコード修正 |
| N/A | パッケージマネージャー検出失敗 | lockファイルが存在しない | npmがデフォルトで使用される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

子プロセスの終了コードがprocess.exitCodeに伝搬されるため、非ゼロの場合はアップグレード処理が失敗したことを示す。@next/codemodのエラーメッセージに従い、手動でコード修正を行う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | N/A |
| ロールバック条件 | なし（Gitを使用して変更を元に戻すことが推奨される） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクトのアップグレード |
| 目標処理時間 | プロジェクト規模とコードモッド数に依存 |
| メモリ使用量上限 | @next/codemodの処理に依存 |

## 排他制御

プロジェクトのソースコードに変更が加えられるため、他のビルドプロセスやエディタとの同時操作に注意が必要。アップグレード前にGitの未コミット変更がないことを確認することが推奨される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 処理中 | @next/codemodの標準出力（stdio: 'inherit'で直接転送） |
| エラーログ | 処理中 | @next/codemodの標準エラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | CLIコマンドのため監視対象外 |

## 備考

- 本コマンドはCLIエントリポイント`packages/next/src/cli/next-upgrade.ts`から実行される。
- 実際のアップグレードロジックは@next/codemod@canaryパッケージに委譲されており、本コマンドはランチャーとしての役割のみを果たす。
- canary版の@next/codemodを常に使用する（`@next/codemod@canary`）。これにより最新のコードモッドが適用される。
- パッケージマネージャーの検出はgetPkgManager関数で行われ、yarn.lockやpnpm-lock.yamlの存在に基づいて判定される。
- yarn dlx対応の確認は`yarn dlx --help`の実行結果で判定される。
- stdio: 'inherit'により、子プロセスの入出力が直接端末に接続される。
- --verboseオプション指定時は@next/codemodに--verboseフラグが渡される。
