# バッチ設計書 41-next telemetry

## 概要

本ドキュメントは、Next.jsのテレメトリ収集機能の有効/無効を切り替えるCLIコマンド `next telemetry` のバッチ設計書である。

### 本バッチの処理概要

`next telemetry` コマンドは、Next.jsの匿名テレメトリ収集の有効化・無効化を行うCLIユーティリティである。ユーザーのプライバシー設定を管理し、現在のテレメトリ収集状態を表示する。

**業務上の目的・背景**：Next.jsはフレームワークの改善のために匿名のテレメトリデータを収集している。しかし、ユーザーのプライバシーを尊重するため、テレメトリ収集のオプトアウト機能を提供する必要がある。本バッチは、ユーザーが簡単にテレメトリ収集の有効/無効を切り替えられるインターフェースを提供し、GDPR等のプライバシー規制への対応も兼ねている。

**バッチの実行タイミング**：ユーザーが `next telemetry` コマンドを手動で実行した際に随時実行される。CLIコマンドとして提供されるため、スケジュール実行ではなく、ユーザーの任意のタイミングで利用される。

**主要な処理内容**：
1. Telemetryクラスの初期化（設定ファイルの読み込み）
2. コマンドライン引数の解析（enable/disable/状態表示）
3. テレメトリ設定の変更（conf設定ファイルへの永続化）
4. 現在のテレメトリ収集状態のコンソール出力

**前後の処理との関連**：本コマンドは独立したCLIコマンドであり、他のバッチとの直接的な依存関係はない。ただし、テレメトリ設定は `next build`、`next dev` などの他のNext.jsコマンド実行時のテレメトリデータ送信動作に影響する。テレメトリストレージクラス（`Telemetry`）は各コマンド内部で共通的に使用される。

**影響範囲**：テレメトリ設定ファイル（`~/.config/configstore/nextjs.json` または CI/Docker環境では `{distDir}/cache`）に書き込みを行う。設定変更後は全てのNext.jsコマンドでテレメトリ収集の動作が変更される。

## バッチ種別

設定管理 / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（CLIコマンド実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Next.jsインストール済み | `next` パッケージがインストールされていること |
| Node.js実行環境 | Node.jsランタイムが利用可能であること |

### 実行可否判定

特別な実行可否判定はない。コマンドが実行されれば常に処理を開始する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --enable | boolean | No | false | テレメトリ収集を有効にする |
| --disable | boolean | No | false | テレメトリ収集を無効にする |
| arg | string | No | - | "enable" または "disable" を位置引数として指定可能 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テレメトリ設定ファイル | JSON | `conf` ライブラリが管理する設定ファイル（`~/.config/configstore/nextjs.json`） |
| 環境変数 `NEXT_TELEMETRY_DISABLED` | 文字列 | 設定されている場合、テレメトリは無効と判定される |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| テレメトリ設定ファイル | JSON | テレメトリの有効/無効設定を永続化 |
| 標準出力 | テキスト | 現在のテレメトリ状態メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | `nextjs.json`（confライブラリが管理） |
| 出力先 | `~/.config/configstore/` または CI/Docker環境では `{distDir}/cache` |
| 文字コード | UTF-8 |
| 区切り文字 | - (JSON形式) |

## 処理フロー

### 処理シーケンス

```
1. Telemetryクラスのインスタンス化
   └─ process.cwd()をdistDirとして設定ファイルを読み込む
2. 現在のテレメトリ有効/無効状態の取得
   └─ conf設定ファイルから telemetry.enabled キーの値を読み込む
3. コマンドライン引数の解析
   └─ options.enable / options.disable / 位置引数を確認
4. テレメトリ設定の変更（enable/disableの場合）
   └─ telemetry.setEnabled() で設定を永続化
5. 状態メッセージの出力
   └─ 有効/無効に応じたメッセージをコンソールに表示
6. テレメトリ情報URLの表示
   └─ https://nextjs.org/telemetry へのリンクを表示
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド実行開始] --> B[Telemetryクラス初期化]
    B --> C{引数チェック}
    C -->|enable| D[テレメトリを有効化]
    C -->|disable| E[テレメトリを無効化]
    C -->|引数なし| F[現在の状態表示のみ]
    D --> G[成功メッセージ出力]
    E --> H{既に無効化済みか?}
    H -->|Yes| I[既に無効化済みメッセージ]
    H -->|No| J[無効化完了メッセージ]
    G --> K[現在の状態表示]
    I --> K
    J --> K
    F --> K
    K --> L[テレメトリ情報URL表示]
    L --> M[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチではデータベース操作は行わない。設定の永続化にはファイルシステム上のJSON設定ファイルを使用する。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定ファイルアクセスエラー | conf初期化時に権限エラーが発生 | confをnullに設定し、テレメトリ無効として動作継続 |
| - | 設定ファイル書き込みエラー | telemetry.setEnabled()呼び出し時にファイルシステムエラー | confがnullの場合は設定変更がスキップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

設定ファイルへのアクセスが失敗した場合、confがnullとなりテレメトリは自動的に無効として扱われる。ユーザーへの明示的なエラー通知は行わず、グレースフルに動作を継続する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | 設定変更時に即座にファイル書き込み |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（1回の設定変更） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 50MB以下 |

## 排他制御

排他制御は行わない。設定ファイルへの書き込みはconfライブラリが管理する。同時に複数プロセスから設定変更が行われた場合、最後の書き込みが優先される（last-write-wins）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 状態ログ | コマンド実行時 | テレメトリの有効/無効状態 |
| 成功ログ | enable時 | "Success!" メッセージ |
| 情報ログ | disable時 | 設定保存先パスまたは既に無効化済みメッセージ |
| 案内ログ | 常時 | テレメトリ詳細情報URL |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチはユーザーが手動実行するCLIコマンドのため、監視・アラート設定は不要。

## 備考

- テレメトリデータは完全に匿名化されており、SHA-256ハッシュ化にソルトを使用している
- 環境変数 `NEXT_TELEMETRY_DISABLED` を設定することでもテレメトリを無効化可能
- CI環境やDocker環境ではストレージディレクトリが `{distDir}/cache` に変更される
- テレメトリ初回有効時にはユーザーへの通知メッセージが表示される（`telemetry.notifiedAt` で管理）
- ソースコード: `packages/next/src/cli/next-telemetry.ts`, `packages/next/src/telemetry/storage.ts`
