# バッチ設計書 42-clean

## 概要

本ドキュメントは、Next.jsモノレポ全体のクリーンアップを実行するバッチ `clean` のバッチ設計書である。

### 本バッチの処理概要

`clean` バッチは、lernaを使用してモノレポ内の全パッケージの `node_modules` ディレクトリおよび `dist` ディレクトリを削除し、ビルド成果物と依存関係をクリーンな状態にリセットする。

**業務上の目的・背景**：Next.jsモノレポは多数のパッケージから構成されており、開発中にビルド成果物や依存関係が不整合な状態になることがある。ブランチ切り替え後のビルドエラー、古いキャッシュによる問題、依存関係の競合などを解消するために、全パッケージのクリーンアップを一括で行う必要がある。本バッチはこれらの問題を解決し、クリーンな開発環境を再構築するための基盤処理である。

**バッチの実行タイミング**：開発者が手動で実行する。主にブランチ切り替え後やビルドエラー発生時、依存関係の不整合が疑われる場合に使用される。CI環境では通常使用されない。

**主要な処理内容**：
1. `lerna clean -y` による全パッケージの `node_modules` 削除
2. `lerna run clean` による各パッケージ固有のcleanスクリプト実行
3. `lerna exec 'node ../../scripts/rm.mjs dist'` による全パッケージの `dist` ディレクトリ削除

**前後の処理との関連**：本バッチ実行後は `pnpm install` による依存関係の再インストールおよび `pnpm build` によるビルドが必要となる。No.43 postinstallバッチがインストール後に自動実行される。

**影響範囲**：モノレポ内の全パッケージの `node_modules` および `dist` ディレクトリが削除される。実行後はビルド成果物が失われるため、再ビルドが必須となる。

## バッチ種別

クリーンアップ / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動（`pnpm clean` コマンド実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| pnpmインストール済み | pnpmパッケージマネージャーが利用可能であること |
| lernaインストール済み | lernaがnode_modules内に存在すること |
| モノレポルートで実行 | リポジトリのルートディレクトリで実行すること |

### 実行可否判定

特別な実行可否判定はない。コマンドが実行されれば常に処理を開始する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| lerna.json | JSON | lernaの設定ファイル（パッケージ一覧の定義） |
| 各パッケージのpackage.json | JSON | 各パッケージのcleanスクリプト定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ファイルシステム | ディレクトリ削除 | node_modulesおよびdistディレクトリの削除 |
| 標準出力 | テキスト | 削除処理の進捗・完了メッセージ |

### 出力ファイル仕様

本バッチはファイルの削除のみを行い、新規ファイルの出力はない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | - |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. lerna clean -y
   └─ 全パッケージのnode_modulesディレクトリを確認なしで削除
2. lerna run clean
   └─ 各パッケージのpackage.jsonに定義されたcleanスクリプトを実行
3. lerna exec 'node ../../scripts/rm.mjs dist'
   └─ 全パッケージのdistディレクトリをrm.mjsスクリプトで削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[lerna clean -y]
    B --> C[全パッケージのnode_modules削除]
    C --> D[lerna run clean]
    D --> E[各パッケージのcleanスクリプト実行]
    E --> F[lerna exec rm.mjs dist]
    F --> G[全パッケージのdistディレクトリ削除]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイルシステムエラー | node_modulesまたはdistの削除時に権限エラー | 管理者権限で再実行、またはファイルロックを解除 |
| - | lerna未インストール | lernaコマンドが見つからない | pnpm installを先に実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

削除処理が途中で失敗した場合、手動で残存するnode_modulesやdistディレクトリを削除し、再度コマンドを実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | なし（削除操作のため復元不可） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | モノレポ内の全パッケージ（約20パッケージ） |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | 256MB以下 |

## 排他制御

排他制御は行わない。実行中に他のビルドプロセスやインストールプロセスが動作していないことを前提とする。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各パッケージ処理時 | 削除対象パッケージ名と処理状況 |
| 完了ログ | 全処理完了時 | クリーンアップ完了メッセージ |
| エラーログ | エラー発生時 | エラー詳細とスタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチは開発者が手動で実行するため、監視・アラート設定は不要。

## 備考

- 本バッチは `pnpm clean` で実行される（package.jsonのscripts.cleanに定義）
- 実行コマンド: `lerna clean -y && lerna run clean && lerna exec 'node ../../scripts/rm.mjs dist'`
- クリーンアップ後は必ず `pnpm install` と `pnpm build` の実行が必要
- ファイル削除にはカスタムの `scripts/rm.mjs` スクリプトが使用されている
- ソースコード: `package.json` (scripts.clean)
