# バッチ設計書 43-postinstall

## 概要

本ドキュメントは、Next.jsモノレポのインストール後の初期化処理を行うバッチ `postinstall` のバッチ設計書である。

### 本バッチの処理概要

`postinstall` バッチは、`pnpm install` 実行後に自動的に呼び出されるフックスクリプトで、Git設定の初期化とSWCネイティブバイナリのインストールを順次実行する。

**業務上の目的・背景**：Next.jsモノレポの開発環境を正しくセットアップするためには、依存関係のインストール後にGit設定の適用とプラットフォーム固有のネイティブバイナリのインストールが必要である。本バッチはこれらの初期化処理を自動化し、開発者が手動で設定する必要をなくすことで、環境構築の効率化と一貫性の確保を実現する。

**バッチの実行タイミング**：`pnpm install` の実行完了後に自動的にトリガーされる（npmのpostinstallライフサイクルフック）。リポジトリの初回クローン後、依存関係の更新後、およびブランチ切り替え後の `pnpm install` 実行時に動作する。

**主要な処理内容**：
1. `git-configure.mjs` による Git設定の初期化（index.skipHash設定、errors.jsonマージドライバーのインストール）
2. `install-native.mjs` による @next/swc ネイティブバイナリパッケージのインストール

**前後の処理との関連**：`pnpm install` の後続処理として自動実行される。No.42 cleanバッチ実行後のリインストール時にも動作する。本バッチ完了後にビルド（No.1 next build または No.2 turbo run build）を実行可能な状態となる。

**影響範囲**：ローカルGit設定（.git/config）の変更、node_modules/@next/ 配下へのSWCネイティブバイナリパッケージのインストールが行われる。

## バッチ種別

初期化 / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（pnpm install実行後に自動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | npmライフサイクルフック（postinstall） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| pnpm installが正常完了 | 依存関係のインストールが完了していること |
| Git初期化済み | .gitディレクトリが存在すること（git-configure.mjsの前提） |
| Node.js実行環境 | Node.jsランタイムが利用可能であること |

### 実行可否判定

npmのpostinstallフックにより自動判定。`pnpm install` が正常に完了した場合に実行される。`NEXT_SKIP_NATIVE_POSTINSTALL` 環境変数が設定されている場合、ネイティブバイナリのインストールはスキップされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NEXT_SKIP_NATIVE_POSTINSTALL | 環境変数 | No | 未設定 | 設定時はSWCネイティブバイナリのインストールをスキップ |
| NEXT_TEST_PREFER_OFFLINE | 環境変数 | No | 未設定 | "1"の場合、pnpmに--prefer-offlineオプションを付与 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/next/package.json | JSON | Next.jsのバージョン番号を取得 |
| package.json | JSON | packageManager情報を取得 |
| node_modules/@next/ | ディレクトリ | 既存のSWCバイナリバージョン確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .git/config | Git設定 | index.skipHash設定、マージドライバー設定 |
| node_modules/@next/swc-* | バイナリパッケージ | プラットフォーム固有のSWCネイティブバイナリ |
| 標準出力 | テキスト | インストール進捗メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | @next/swc-{platform} パッケージ群 |
| 出力先 | node_modules/@next/ |
| 文字コード | - (バイナリ) |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. git-configure.mjs の実行
   ├─ git config index.skipHash false の設定
   └─ errors.json Gitマージドライバーのインストール
2. install-native.mjs の実行
   ├─ NEXT_SKIP_NATIVE_POSTINSTALL環境変数チェック（設定時はスキップ）
   ├─ packages/next/package.jsonからNext.jsバージョン取得
   ├─ 既存の@next/swc-*パッケージのバージョン確認
   ├─ バージョンが一致する場合はスキップ
   ├─ 一時ディレクトリ作成（/tmp/next-swc-{timestamp}）
   ├─ ダミーpackage.jsonを作成（全プラットフォーム対応のoptionalDependencies定義）
   ├─ pnpm add next@{version} でSWCバイナリを一時ディレクトリにインストール
   ├─ インストールされたパッケージをnode_modules/@next/にコピー
   └─ 一時ディレクトリの削除
```

### フローチャート

```mermaid
flowchart TD
    A[postinstall開始] --> B[git-configure.mjs実行]
    B --> C[git config index.skipHash false]
    C --> D[errors.jsonマージドライバーインストール]
    D --> E[install-native.mjs実行]
    E --> F{NEXT_SKIP_NATIVE_POSTINSTALL?}
    F -->|設定あり| G[スキップ]
    F -->|未設定| H[Next.jsバージョン取得]
    H --> I{既存SWCバージョン一致?}
    I -->|一致| J[スキップ]
    I -->|不一致| K[一時ディレクトリ作成]
    K --> L[pnpm addでSWCバイナリインストール]
    L --> M[node_modules/@next/にコピー]
    M --> N[一時ディレクトリ削除]
    G --> O[処理終了]
    J --> O
    N --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Git設定エラー | git configコマンドが失敗 | reject: false でエラーを無視し処理を継続 |
| - | マージドライバーインストール失敗 | scripts/merge-errors-json/installが失敗 | reject: false でエラーを無視し処理を継続 |
| - | SWCバイナリインストール失敗 | pnpm addが失敗またはプラットフォーム非対応 | エラーをcatchしてログ出力、処理を継続 |
| - | ファイルコピーエラー | node_modulesへのコピーに失敗 | エラーをcatchしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

git-configure.mjsおよびinstall-native.mjsはいずれもエラー発生時にグレースフルに処理を継続する設計となっている。SWCバイナリのインストール失敗時は、ビルド時にWasmフォールバックが使用される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 8プラットフォーム分のSWCバイナリパッケージ |
| 目標処理時間 | 30秒以内（ネットワーク状況依存） |
| メモリ使用量上限 | 512MB以下 |

## 排他制御

排他制御は行わない。`pnpm install` のpostinstallフックとして実行されるため、通常は単一プロセスで動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | SWCスキップ時 | "Skipping next-swc postinstall due to NEXT_SKIP_NATIVE_POSTINSTALL env" |
| 情報ログ | バージョン一致時 | "@next/{pkg}@{version} already installed, skipping" |
| 完了ログ | インストール完了時 | "Installed the following binary packages: {pkgs}" |
| エラーログ | エラー発生時 | エラー詳細とスタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチはpnpm installの後処理として自動実行されるため、独立した監視・アラート設定は不要。

## 備考

- 本バッチは `node scripts/git-configure.mjs && node scripts/install-native.mjs` として順次実行される
- サポート対象プラットフォーム: darwin-arm64, darwin-x64, linux-arm64-gnu, linux-arm64-musl, linux-x64-gnu, linux-x64-musl, win32-arm64-msvc, win32-x64-msvc
- 一時ディレクトリは `/tmp/next-swc-{timestamp}` に作成され、処理完了後に削除される
- 既存のSWCバイナリバージョンがNext.jsバージョンと一致する場合はインストールをスキップする最適化が実装されている
- ソースコード: `package.json` (scripts.postinstall), `scripts/git-configure.mjs`, `scripts/install-native.mjs`
