# バッチ設計書 44-check-is-release

## 概要

本ドキュメントは、Gitコミットメッセージからリリースバージョンを検出するバッチ `check-is-release` のバッチ設計書である。

### 本バッチの処理概要

`check-is-release` バッチは、指定されたGitコミット（またはHEAD）のコミットメッセージを解析し、リリースバージョンのパターン（セマンティックバージョニング）に一致するかどうかを判定する。一致する場合はバージョン文字列を出力し、一致しない場合はエラー終了する。

**業務上の目的・背景**：Next.jsのリリースパイプラインにおいて、特定のコミットがリリース用のpublishコミットであるかを自動判定する必要がある。本バッチは `publish-release`（No.6）から呼び出され、CIパイプラインでリリース処理を実行するかスキップするかの判断基準を提供する。これにより、リリース自動化の正確性と信頼性を確保する。

**バッチの実行タイミング**：CI/CDパイプラインのリリースワークフロー内で、publish-releaseスクリプトから呼び出される。リリースタグが付与されたコミットのプッシュ時に実行される。

**主要な処理内容**：
1. コマンドライン引数からコミットID（オプション）を取得
2. `git log` コマンドでコミットメッセージを取得
3. コミットメッセージの最後の文字列をバージョン文字列として抽出
4. セマンティックバージョニング正規表現（`v{major}.{minor}.{patch}(-{prerelease}.{number})`）でマッチング
5. マッチした場合はバージョン文字列を出力して正常終了、しない場合はエラー終了

**前後の処理との関連**：No.6 publish-releaseバッチから呼び出される。本バッチの判定結果に基づいて、publish-releaseがパッケージの公開処理を実行するかどうかが決まる。

**影響範囲**：読み取り専用の処理であり、ファイルシステムやGitリポジトリへの変更は行わない。プロセスの終了コードでリリース判定結果を返す。

## バッチ種別

判定処理 / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリースワークフロー内） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | publish-releaseスクリプトからの呼び出し / CIワークフロー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ内で実行 | git logコマンドが実行可能であること |
| Node.js実行環境 | Node.jsランタイムが利用可能であること |

### 実行可否判定

特別な実行可否判定はない。コマンドが実行されれば常に処理を開始する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| commitId | string | No | "" (HEAD) | 対象コミットのハッシュ。省略時は最新コミット |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Gitコミット履歴 | テキスト | git logから取得するコミットメッセージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | リリースバージョン文字列（例: v15.0.0）またはデバッグ情報 |
| プロセス終了コード | 数値 | 0: リリースコミット、1: 非リリースコミット |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | - |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ process.argv[2] からコミットIDを取得（省略時は空文字列）
2. Gitコミットメッセージの取得
   └─ git log -n 1 --pretty='format:%B' でコミットメッセージ全文を取得
3. バージョン文字列の抽出
   └─ コミットメッセージをスペースで分割し、最後の要素をバージョン候補とする
4. 正規表現によるバージョンパターンマッチ
   └─ /^v\d{1,}\.\d{1,}\.\d{1,}(-\w{1,}\.\d{1,})?$/ でマッチング
5. 結果出力
   └─ マッチ: バージョン文字列を出力しexit(0)
   └─ 不一致: デバッグ情報を出力しexit(1)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[コミットID取得]
    B --> C[git logでコミットメッセージ取得]
    C --> D[メッセージ末尾のバージョン文字列抽出]
    D --> E{セマンティックバージョンパターン一致?}
    E -->|Yes| F[バージョン文字列を出力]
    F --> G[exit code 0で終了]
    E -->|No| H[デバッグ情報を出力]
    H --> I[exit code 1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit(1) | 非リリースコミット | コミットメッセージがバージョンパターンに一致しない | 正常動作。呼び出し元でexit codeを確認し処理分岐 |
| - | Gitコマンドエラー | git logコマンドが失敗 | Gitリポジトリの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

本バッチは判定処理のみを行うため、障害時は呼び出し元（publish-release）側でエラーハンドリングを行う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用処理） |
| コミットタイミング | - |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（1コミットの判定） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 50MB以下 |

## 排他制御

排他制御は不要。読み取り専用の処理であり、並行実行しても問題は生じない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | リリースコミット判定時 | バージョン文字列（例: v15.0.0-canary.1） |
| 結果ログ | 非リリースコミット判定時 | "not publish commit" と共にcommitId, commitMsg, versionStringを出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチはCIパイプライン内で実行されるため、CI側の監視機能で管理される。

## 備考

- バージョンパターン正規表現: `/^v\d{1,}\.\d{1,}\.\d{1,}(-\w{1,}\.\d{1,})?$/`
- 対応するバージョン形式の例: `v15.0.0`, `v15.1.0-canary.1`, `v14.2.3-rc.1`, `v15.0.0-beta.1`
- コミットメッセージの最後のスペース区切り文字列をバージョン候補として使用する
- publish-release（No.6）から呼び出されるユーティリティスクリプト
- ソースコード: `scripts/check-is-release.js`
