# バッチ設計書 45-get-changed-tests

## 概要

本ドキュメントは、origin/canaryとの差分から変更されたテストファイルを検出するバッチ `get-changed-tests` のバッチ設計書である。

### 本バッチの処理概要

`get-changed-tests` バッチは、現在のブランチと `origin/canary`（またはGitHub Actions環境では `HEAD~1`）との差分を解析し、変更されたテストファイルを検出する。検出されたテストはdev/prod/deployモード別に分類され、呼び出し元の `test-new-tests`（No.19）バッチに提供される。

**業務上の目的・背景**：Next.jsの開発において、PRごとに変更されたテストを自動的に検出し実行することで、テストの品質を確保する。特にフレーク（不安定なテスト）検出のために、変更されたテストを複数回実行するワークフローを支援する。手動でテストファイルを特定する手間を省き、CIパイプラインの自動化と効率化に貢献する。

**バッチの実行タイミング**：CI環境（GitHub Actions）でPRが作成・更新された際に、`test-new-tests`（No.19）から呼び出されて実行される。

**主要な処理内容**：
1. Git情報（ブランチ名、リモートURL、コミットSHA、canaryブランチかどうか）の取得
2. canaryブランチの場合はスキップ（空配列を返す）
3. 差分リビジョンの決定（GitHub Actionsでは `HEAD~1`、それ以外では `origin/canary`）
4. `git diff` による変更ファイル一覧の取得
5. テストファイルパターン（`test/**/*.test.(js|ts|tsx)`）に一致するファイルの抽出
6. テストディレクトリに基づくdev/prod/deployモードへの分類

**前後の処理との関連**：No.19 test-new-testsバッチから呼び出されるライブラリモジュールである。本バッチの出力（テストファイルリスト）は、test-new-testsでのテスト実行対象の決定に使用される。

**影響範囲**：読み取り専用の処理であり、ファイルシステムやGitリポジトリへの変更は行わない（ただし `git fetch origin canary` によるリモート参照の更新を除く）。

## バッチ種別

分析処理 / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI環境でPR更新時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | test-new-testsスクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ内で実行 | git diffコマンドが実行可能であること |
| Node.js実行環境 | Node.jsランタイムが利用可能であること |
| リモートorigin設定済み | origin/canaryへのfetchが可能であること |

### 実行可否判定

canaryブランチ（`branchName === 'canary'` かつ `remoteUrl` が `vercel/next.js` を含む）の場合はフレーク検出をスキップし、空のテストリストを返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_EVENT_PATH | 環境変数 | No | - | GitHub Actionsイベントデータのファイルパス |
| GITHUB_REF_NAME | 環境変数 | No | - | GitHubのブランチ名 |
| GITHUB_REPOSITORY | 環境変数 | No | - | GitHubリポジトリ名 |
| GITHUB_SHA | 環境変数 | No | - | GitHubコミットSHA |
| GITHUB_ACTIONS | 環境変数 | No | - | GitHub Actions実行判定 |
| GITHUB_EVENT_NAME | 環境変数 | No | - | GitHub Actionsイベント名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Gitリポジトリ | テキスト | git diffによる変更ファイル一覧 |
| GitHub Actionsイベントデータ | JSON | PRのブランチ情報、コミットSHA等 |
| ファイルシステム | ファイル存在チェック | 変更テストファイルの存在確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 戻り値（オブジェクト） | JavaScript Object | { devTests: string[], prodTests: string[], deployTests: string[], commitSha: string } |
| 標準出力 | テキスト | デバッグ情報（ブランチ名、差分、検出テスト一覧） |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | - |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. Git情報の取得
   ├─ GITHUB_EVENT_PATHからPR情報読み込み（GitHub Actions環境）
   ├─ ブランチ名の取得（イベントデータ > 環境変数 > git rev-parse）
   ├─ リモートURLの取得
   └─ コミットSHAの取得
2. canaryブランチチェック
   └─ canaryブランチの場合は空配列を返して終了
3. 差分リビジョンの決定
   ├─ GitHub Actions pull_requestイベント: HEAD~1
   └─ その他: origin/canary（fetchを事前実行）
4. git diffの実行
   └─ 変更ファイル一覧を取得
5. テストファイルのフィルタリング
   ├─ パターン: test/**/*.test.(js|ts|tsx)
   └─ ファイル存在チェック
6. モード別分類
   ├─ test/e2e/: devTests + prodTests + deployTests
   ├─ test/integration/: devTests + prodTests
   ├─ test/prod*: prodTests
   └─ test/development*: devTests
7. 結果出力
   └─ 分類結果をJSON形式でコンソール出力し、オブジェクトを返す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Git情報取得]
    B --> C{canaryブランチ?}
    C -->|Yes| D[空配列を返して終了]
    C -->|No| E[差分リビジョン決定]
    E --> F{GitHub Actions PR?}
    F -->|Yes| G[HEAD~1]
    F -->|No| H[origin/canary fetch + 設定]
    G --> I[git diff実行]
    H --> I
    I --> J[変更ファイル一覧取得]
    J --> K[テストファイルフィルタリング]
    K --> L[ファイル存在チェック]
    L --> M[モード別分類]
    M --> N[結果出力]
    N --> O[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | git diffエラー | git diffコマンドが失敗 | エラーをcatchし空文字列を返す（処理継続） |
| - | git fetchエラー | origin/canaryのfetchが失敗 | リモート情報をログ出力しエラーを記録（処理継続） |
| - | イベントデータ読み込みエラー | GITHUB_EVENT_PATHのファイルが存在しない | 例外をcatchし空オブジェクトを使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（git diffのエラー時は空結果で継続） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

git diffの実行に失敗した場合、空のstdoutを返し、結果的にテストは検出されない。呼び出し元のtest-new-testsでは「No added/changed tests detected」としてスキップされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（読み取り専用処理） |
| コミットタイミング | - |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 変更ファイル数（通常1-100件程度） |
| 目標処理時間 | 10秒以内 |
| メモリ使用量上限 | 128MB以下 |

## 排他制御

排他制御は不要。読み取り専用の処理であり、並行実行しても問題は生じない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | Git情報取得後 | ブランチ名、リモートURL、canaryフラグ、コミットSHA |
| 情報ログ | diff実行後 | git diffの出力結果 |
| 情報ログ | canaryスキップ時 | "Skipping flake detection for canary" |
| 結果ログ | テスト検出後 | 検出されたdevTests, prodTests, deployTestsのJSON出力 |
| エラーログ | fetchエラー時 | リモート情報とエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチはCI環境内で実行されるため、CI側の監視機能で管理される。

## 備考

- テストファイルのモード分類ルール:
  - `test/e2e/` 配下: devTests, prodTests, deployTests の全モードに追加
  - `test/integration/` 配下: devTests, prodTests に追加
  - `test/prod*` 配下: prodTests のみ
  - `test/development*` 配下: devTests のみ
- GitHub Actions環境の差分検出:
  - pull_requestイベント: マージコミットに対して `HEAD~1` で差分を取得
  - その他: `origin/canary` に対して差分を取得（`--depth=20` で浅いfetch）
- パスのスラッシュはクロスプラットフォーム対応のため正規化される
- ソースコード: `scripts/get-changed-tests.mjs`, `scripts/git-info.mjs`
