# バッチ設計書 46-pull-turbo-cache

## 概要

本ドキュメントは、Turboリモートキャッシュからネイティブビルドキャッシュを取得するバッチ `pull-turbo-cache` のバッチ設計書である。

### 本バッチの処理概要

`pull-turbo-cache` バッチは、Turborepoのリモートキャッシュ機能を利用して、SWCネイティブバイナリのビルドキャッシュの有無を確認し、キャッシュが利用可能な場合はダウンロードする。CI環境でネイティブビルドの所要時間を大幅に削減するために使用される。

**業務上の目的・背景**：Next.jsのSWCネイティブバイナリ（Rust製）のビルドには時間がかかる。CIパイプラインにおいて毎回フルビルドを行うとビルド時間が大幅に増加するため、Turborepoのリモートキャッシュを活用してビルド成果物を再利用する。本バッチにより、CIの実行時間を短縮し、開発のイテレーション速度を向上させる。

**バッチの実行タイミング**：CI環境でネイティブバイナリのビルド前に実行される。GitHub Actionsワークフロー内でキャッシュの事前取得ステップとして使用される。

**主要な処理内容**：
1. Turboコマンドの準備（`pnpm dlx turbo` によるTurborepoの利用）
2. `turbo run cache-build-native --dry=json` でキャッシュ状態をドライラン確認
3. ドライラン結果のJSON解析、対象タスクの特定
4. キャッシュが利用可能（localまたはremote）な場合はキャッシュをプル
5. キャッシュが利用不可能な場合はスキップしてログ出力

**前後の処理との関連**：ネイティブビルド（No.3 swc-build-native）の前段処理として実行される。キャッシュが利用可能な場合はビルドが高速化される。

**影響範囲**：Turboキャッシュディレクトリへのビルド成果物の書き込みが行われる。既存のビルド成果物が上書きされる可能性がある。

## バッチ種別

キャッシュ取得 / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI環境でビルド前に実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIワークフロー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js実行環境 | Node.jsランタイムが利用可能であること |
| pnpm利用可能 | pnpm dlxコマンドが実行可能であること |
| Turboリモートキャッシュ設定済み | Turborepoのリモートキャッシュが設定されていること |

### 実行可否判定

特別な実行可否判定はない。キャッシュが利用不可能な場合はスキップメッセージを出力して正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| target | string | Yes | - | ビルド対象（コマンドライン最後の引数） |
| TURBO_VERSION | 環境変数 | No | "latest" | 使用するTurboのバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Turboリモートキャッシュ | バイナリ | ネイティブビルドのキャッシュ成果物 |
| turbo dry run結果 | JSON | キャッシュ状態の確認結果 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Turboキャッシュディレクトリ | バイナリ | キャッシュからダウンロードされたビルド成果物 |
| 標準出力 | テキスト | キャッシュ状態、タスクID、ハッシュ等の情報 |
| 標準エラー出力 | テキスト | Turboコマンドのログ出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Turboが管理するキャッシュファイル |
| 出力先 | Turboキャッシュディレクトリ |
| 文字コード | - (バイナリ) |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. ビルド対象の取得
   └─ process.argvの最後の引数からtargetを取得
2. Turboコマンドの準備
   └─ pnpm dlx turbo@{version} を使用（TURBO_VERSIONまたはlatest）
3. ドライランの実行
   └─ turbo run cache-build-native --dry=json -- {target} でキャッシュ状態を確認
4. ドライラン結果の解析
   ├─ JSON結果をパース
   └─ コマンドが<NONEXISTENT>でないタスクを検索
5. キャッシュの可否判定
   ├─ task.cache.local または task.cache.remote がtrueの場合
   │   └─ turbo run cache-build-native -- {target} でキャッシュをプル
   └─ キャッシュなしの場合
       └─ 警告メッセージを出力してスキップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[target引数取得]
    B --> C[Turboドライラン実行]
    C --> D[JSON結果解析]
    D --> E{有効なタスク存在?}
    E -->|No| F[警告ログ出力して終了]
    E -->|Yes| G{キャッシュ利用可能?}
    G -->|Yes| H[キャッシュ状態ログ出力]
    H --> I[turbo runでキャッシュプル]
    I --> J[処理終了]
    G -->|No| K[キャッシュなし警告出力]
    K --> J
    F --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Turboコマンドエラー | pnpm dlx turboの実行が失敗 | 非ゼロ終了コードまたはシグナルでPromiseをreject |
| - | JSON解析エラー | ドライラン結果が不正なJSON | JSON.parseでエラー発生 |
| - | タスク未検出 | 有効なタスクが見つからない | 警告ログを出力して正常終了 |
| - | キャッシュプルエラー | キャッシュのダウンロードが失敗 | 非ゼロ終了コードでPromiseをreject |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

キャッシュの取得に失敗した場合、後続のネイティブビルド処理がフルビルドとして実行される。キャッシュは最適化のためのものであり、失敗してもビルドプロセス自体は継続可能。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1タスク（1ターゲット分のキャッシュ） |
| 目標処理時間 | 60秒以内（ネットワーク速度依存） |
| メモリ使用量上限 | 256MB以下 |

## 排他制御

排他制御は行わない。CI環境では通常、ジョブ単位で独立して実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | キャッシュ利用可能時 | "Cache Status", タスクID, ハッシュ, キャッシュ状態 |
| 警告ログ | タスク未検出時 | "Failed to find related turbo task" |
| 警告ログ | キャッシュなし時 | "No turbo cache was available, continuing..." |
| エラーログ | Turboコマンドエラー時 | 標準エラー出力にTurboのログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

本バッチはCI環境内で実行されるため、CI側の監視機能で管理される。

## 備考

- Turboのバージョンは `TURBO_VERSION` 環境変数で制御可能（デフォルトは `latest`）
- `pnpm dlx` でTurborepoを一時的にダウンロードして実行する方式を採用
- ドライランで `--dry=json` オプションを使用してキャッシュ状態を事前確認する
- タスクのcommandが `<NONEXISTENT>` の場合はスキップ対象として扱う
- キャッシュはlocalキャッシュとremoteキャッシュの両方をサポート
- spawnによる子プロセス実行で、stderrは親プロセスにパイプ、stdoutはバッファリング
- ソースコード: `scripts/pull-turbo-cache.js`
