# バッチ設計書 47-deploy-docs

## 概要

本ドキュメントは、Next.jsドキュメントサイトをVercelにデプロイするバッチ `deploy-docs` のバッチ設計書である。

### 本バッチの処理概要

`deploy-docs` バッチは、Next.jsのドキュメントサイト（`apps/docs`）をVercelプラットフォームにデプロイするシェルスクリプトである。依存関係のインストール、ローカルビルド、Vercel CLIによるプレビューまたはプロダクションデプロイを行う。

**業務上の目的・背景**：Next.jsのドキュメントサイトは、フレームワークの利用者が参照する重要なリソースである。ドキュメントの更新をリリースに合わせて迅速にデプロイする必要がある。本バッチはCIパイプライン内でドキュメントのビルドとデプロイを自動化し、ドキュメントの公開プロセスを効率化する。

**バッチの実行タイミング**：CIパイプライン（GitHub Actions）内でドキュメント更新時に実行される。`DEPLOY_ENVIRONMENT` 環境変数により、プレビューデプロイまたはプロダクションデプロイが選択される。

**主要な処理内容**：
1. VERCEL_API_TOKENの存在確認（未設定時はスキップ）
2. corepackのインストールと有効化
3. Vercel CLIのグローバルインストール
4. Vercelプロジェクトのリンク（`next-docs` プロジェクト）
5. 環境変数のプル（preview/production環境別）
6. ローカルビルドの実行
7. プレビルド成果物のデプロイ（tgzアーカイブ形式）

**前後の処理との関連**：独立したデプロイバッチであり、他のバッチとの直接的な依存関係はない。ただし、ドキュメントのソースコードが最新であることが前提となる。

**影響範囲**：Vercelプラットフォーム上のドキュメントサイト（`next-docs`プロジェクト）が更新される。プロダクションデプロイの場合、公開されているドキュメントサイトに即座に反映される。

## バッチ種別

デプロイ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメント更新時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIワークフロー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| VERCEL_API_TOKEN | Vercel APIトークンが環境変数に設定されていること |
| Node.js実行環境 | Node.jsおよびnpmが利用可能であること |
| Bashシェル | bashが利用可能であること |

### 実行可否判定

`VERCEL_API_TOKEN` 環境変数が未設定の場合、スキップメッセージを出力して正常終了（exit 0）する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VERCEL_API_TOKEN | 環境変数 | Yes | - | Vercel APIトークン |
| DEPLOY_ENVIRONMENT | 環境変数 | No | "preview" | デプロイ環境（preview/production） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| apps/docsソースコード | ファイル群 | ドキュメントサイトのソースコード |
| Vercel環境変数 | 設定値 | vercel pullで取得する環境別設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Vercelプラットフォーム | デプロイメント | ドキュメントサイトのデプロイ成果物 |
| 標準出力 | URL | デプロイされたサイトのURL |
| 標準エラー出力 | テキスト | デプロイ進捗ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | - (Vercelプラットフォームにデプロイ) |
| 出力先 | Vercel CDN |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 環境変数チェック
   ├─ DEPLOY_ENVIRONMENTからプロダクションフラグを判定
   └─ VERCEL_API_TOKENの存在確認（未設定時はスキップ）
2. corepackセットアップ
   ├─ corepackがインストール済みか確認
   └─ 未インストールの場合はnpm i -g corepack@0.31でインストール
3. 依存関係設定
   ├─ NEXT_SKIP_NATIVE_POSTINSTALL=1 設定
   └─ PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1 設定
4. Vercel CLI インストール
   └─ npm i -g vercel@latest
5. Vercelプロジェクトリンク
   └─ vercel link --scope vercel --project next-docs
6. 環境変数プル
   └─ vercel pull --environment={preview|production}
7. ローカルビルド
   └─ vercel build
8. デプロイ
   └─ vercel deploy --prebuilt --archive=tgz [--prod]
9. デプロイURL出力
   └─ デプロイされたURLを標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{VERCEL_API_TOKEN設定?}
    B -->|No| C[スキップして終了]
    B -->|Yes| D{DEPLOY_ENVIRONMENT=production?}
    D -->|Yes| E[プロダクションフラグ設定]
    D -->|No| F[プレビューモード]
    E --> G[corepackセットアップ]
    F --> G
    G --> H[環境変数設定]
    H --> I[Vercel CLIインストール]
    I --> J[vercel link]
    J --> K[vercel pull]
    K --> L[vercel build]
    L --> M[vercel deploy --prebuilt]
    M --> N[デプロイURL出力]
    N --> O[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | VERCEL_API_TOKEN未設定 | 環境変数が未設定 | スキップして正常終了（exit 0） |
| - | corepackインストール失敗 | npm i -gが失敗 | スクリプトはset -euo pipefailによりエラーで停止 |
| - | Vercel CLIインストール失敗 | npm i -gが失敗 | スクリプトは即座に終了 |
| - | vercel link失敗 | プロジェクトリンクに失敗 | スクリプトは即座に終了 |
| - | ビルドエラー | vercel buildが失敗 | スクリプトは即座に終了 |
| - | デプロイエラー | vercel deployが失敗 | スクリプトは即座に終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

`set -euo pipefail` により、いずれかのコマンドが失敗した場合はスクリプト全体が即座に終了する。CI環境でジョブの失敗として報告され、手動での再実行が必要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | Vercelのデプロイメントロールバック機能で対応 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1サイト分のデプロイ |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | 4GB以下（ビルドプロセス含む） |

## 排他制御

Vercelプラットフォーム側でデプロイメントの排他制御が行われる。同一プロジェクトへの同時デプロイはVercelのキューイング機能で管理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ステップ開始時 | "Preparing local build for docs...", "Installing dependencies..." 等 |
| 進捗ログ | corepackセットアップ時 | "Installing corepack..." |
| 進捗ログ | Vercel CLI インストール時 | "Installing Vercel CLI..." |
| 進捗ログ | リンク時 | "Linking Vercel project..." |
| 進捗ログ | 環境変数プル時 | "Pulling env for {environment}..." |
| 進捗ログ | ビルド時 | "Building locally with Vercel..." |
| 進捗ログ | デプロイ時 | "Deploying prebuilt output..." |
| 結果ログ | デプロイ完了時 | デプロイURL |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| デプロイ失敗 | 1回 | CIジョブ通知 |
| デプロイ時間 | 10分超過 | CIジョブタイムアウト |

## 備考

- スクリプトは `set -euo pipefail` で厳格なエラーハンドリングを適用
- デプロイ対象のプロジェクト名は `next-docs`
- Vercelスコープは `vercel`
- ビルド時に不要な依存関係のインストールを抑制:
  - `NEXT_SKIP_NATIVE_POSTINSTALL=1`（SWCバイナリのインストールスキップ）
  - `PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD=1`（ブラウザのダウンロードスキップ）
- デプロイは `--prebuilt --archive=tgz` オプションでプレビルド成果物をアーカイブ送信
- ログ出力は主に標準エラー出力（`1>&2`）に送り、標準出力にはデプロイURLのみ出力
- ソースコード: `scripts/deploy-docs.sh`
