# バッチ設計書 48-deploy-examples

## 概要

本ドキュメントは、Next.jsサンプルアプリケーションをVercelにデプロイするバッチ `deploy-examples` のバッチ設計書である。

### 本バッチの処理概要

`deploy-examples` バッチは、Next.jsリポジトリ内の変更されたexampleディレクトリを検出し、各サンプルアプリケーションをVercelプラットフォームにデプロイするシェルスクリプトである。

**業務上の目的・背景**：Next.jsは多数のサンプルアプリケーション（examples/）を提供しており、これらは開発者がNext.jsの機能を学ぶための重要なリソースである。サンプルアプリケーションをVercelにデプロイすることで、ユーザーが実際に動作するサンプルを確認できるようにする。本バッチはデプロイプロセスを自動化し、サンプルの更新を効率的に公開する。

**バッチの実行タイミング**：CIパイプライン内でサンプルアプリケーションの更新時に実行される。`DEPLOY_ENVIRONMENT` 環境変数でプレビュー/プロダクション環境が選択される。

**主要な処理内容**：
1. 変更されたexampleディレクトリの検出（現在はワークアラウンドとして `examples/image-component` が固定指定）
2. `VERCEL_API_TOKEN` の存在確認（未設定時はスキップ）
3. 各変更exampleに対してVercelプロジェクトのリンクとデプロイを実行
4. プロジェクト名はディレクトリパスのスラッシュをハイフンに変換して `nextjs-` プレフィックスを付与

**前後の処理との関連**：独立したデプロイバッチであり、他のバッチとの直接的な依存関係はない。

**影響範囲**：Vercelプラットフォーム上のサンプルアプリケーションプロジェクトが更新される。プロダクションデプロイの場合、公開されているサンプルに即座に反映される。

## バッチ種別

デプロイ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（サンプル更新時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIワークフロー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| VERCEL_API_TOKEN | Vercel APIトークンが環境変数に設定されていること |
| DEPLOY_ENVIRONMENT | デプロイ環境の指定（preview/production） |
| Vercel CLIインストール済み | vercelコマンドが利用可能であること |
| Bashシェル | bashが利用可能であること |

### 実行可否判定

`VERCEL_API_TOKEN` 環境変数が未設定の場合、スキップメッセージを出力して正常終了（exit 0）する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VERCEL_API_TOKEN | 環境変数 | Yes | - | Vercel APIトークン |
| DEPLOY_ENVIRONMENT | 環境変数 | Yes | - | デプロイ環境（preview/production） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| examples/ディレクトリ | ファイル群 | サンプルアプリケーションのソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Vercelプラットフォーム | デプロイメント | 各サンプルアプリケーションのデプロイ |
| 標準出力 | テキスト | デプロイ進捗ログとURL |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | - (Vercelプラットフォームにデプロイ) |
| 出力先 | Vercel CDN |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 変更exampleの検出
   └─ 現在はワークアラウンドとして examples/image-component が固定
      （本来はscripts/run-for-change.mjsで検出予定）
2. デプロイ環境の判定
   └─ DEPLOY_ENVIRONMENT=production の場合は --prod フラグを設定
3. VERCEL_API_TOKENの確認
   └─ 未設定の場合はスキップしてexit 0
4. 各exampleに対するループ処理
   ├─ プロジェクト名の生成（nextjs-{path-with-hyphens}）
   ├─ vercel link --scope vercel --project {project} でプロジェクトリンク
   └─ vercel deploy [--prod] でデプロイ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変更example検出]
    B --> C{DEPLOY_ENVIRONMENT=production?}
    C -->|Yes| D[--prodフラグ設定]
    C -->|No| E[プレビューモード]
    D --> F{VERCEL_API_TOKEN設定?}
    E --> F
    F -->|No| G[スキップして終了]
    F -->|Yes| H[exampleループ開始]
    H --> I[プロジェクト名生成]
    I --> J[vercel link]
    J --> K[vercel deploy]
    K --> L{次のexampleあり?}
    L -->|Yes| H
    L -->|No| M[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | VERCEL_API_TOKEN未設定 | 環境変数が未設定 | スキップして正常終了（exit 0） |
| - | vercel link失敗 | プロジェクトリンクに失敗 | set -euo pipefailによりスクリプト終了 |
| - | vercel deploy失敗 | デプロイに失敗 | set -euo pipefailによりスクリプト終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

`set -euo pipefail` により、いずれかのコマンドが失敗した場合はスクリプト全体が即座に終了する。CI環境でジョブの失敗として報告され、手動での再実行が必要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | Vercelのデプロイメントロールバック機能で対応 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1-5サンプルアプリケーション |
| 目標処理時間 | 5分以内（サンプル数に依存） |
| メモリ使用量上限 | 2GB以下 |

## 排他制御

Vercelプラットフォーム側でデプロイメントの排他制御が行われる。各exampleは独立したプロジェクトとしてデプロイされるため、相互に競合しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各exampleデプロイ開始時 | "Deploying directory {CWD} as {PROJECT} to Vercel..." |
| エラーログ | VERCEL_API_TOKEN未設定時 | "VERCEL_API_TOKEN was not providing, skipping..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| デプロイ失敗 | 1回 | CIジョブ通知 |

## 備考

- 現在、変更example検出ロジック（`scripts/run-for-change.mjs`）にバグがあり、ワークアラウンドとして `examples/image-component` が常時デプロイ対象として固定されている（TODO記載あり）
- プロジェクト命名規則: `nextjs-{ディレクトリパスのスラッシュをハイフンに変換}`
  - 例: `examples/image-component` -> `nextjs-examples-image-component`
- Vercelスコープは `vercel`
- スクリプトは `set -euo pipefail` で厳格なエラーハンドリングを適用
- ソースコード: `scripts/deploy-examples.sh`
