# バッチ設計書 49-deploy-turbopack-docs

## 概要

本ドキュメントは、TurbopackドキュメントサイトをVercelにデプロイするバッチ `deploy-turbopack-docs` のバッチ設計書である。

### 本バッチの処理概要

`deploy-turbopack-docs` バッチは、Turbopackの Rust ドキュメント（cargo doc）を生成するシェルスクリプトである。Turbopack関連のRustクレートから `cargo doc` コマンドでAPIドキュメントを生成する。

**業務上の目的・背景**：Turbopackは Next.js で使用されるRust製のバンドラーであり、その内部APIドキュメントを自動生成して公開する必要がある。本バッチにより、Rustクレートのドキュメントをソースコードから自動生成し、開発者が内部APIを参照できるようにする。これはTurbopackの開発・保守に関わるエンジニアにとって重要なリソースとなる。

**バッチの実行タイミング**：CIパイプライン内でTurbopackのドキュメント更新が必要な際に実行される。

**主要な処理内容**：
1. 対象パッケージの指定（next-napi-bindings, next-api, next-build, next-core, next-custom-transforms）
2. `RUSTDOCFLAGS` の設定（unstable-optionsによるインデックスページ生成の有効化）
3. `cargo doc` によるRustドキュメントの生成（--no-deps オプションで依存クレートのドキュメントを除外）

**前後の処理との関連**：独立したドキュメント生成バッチであり、他のバッチとの直接的な依存関係はない。生成されたドキュメントは別途デプロイステップでVercelに公開される可能性がある。

**影響範囲**：`target/doc/` ディレクトリにRustドキュメントHTMLが生成される。

## バッチ種別

ドキュメント生成 / デプロイ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Turbopackドキュメント更新時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIワークフロー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Rust ツールチェーン | cargo コマンドが利用可能であること |
| nightly Rust | unstable-optionsを使用するためnightlyツールチェーンが必要 |
| Bashシェル | bashが利用可能であること |

### 実行可否判定

特別な実行可否判定はない。Rust ツールチェーンが利用可能であれば実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Rustソースコード | .rs ファイル群 | 対象クレートのRustソースコード |
| Cargo.toml | TOML | クレートのメタデータと依存関係定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| target/doc/ | HTML/CSS/JS | 生成されたRust APIドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | index.html（各クレートのドキュメントルート） |
| 出力先 | target/doc/{crate_name}/ |
| 文字コード | UTF-8 |
| 区切り文字 | - (HTML形式) |

## 処理フロー

### 処理シーケンス

```
1. RUSTDOCFLAGS環境変数の設定
   └─ "-Z unstable-options --enable-index-page" を設定
2. cargo doc の実行
   ├─ 対象パッケージ: next-napi-bindings, next-api, next-build, next-core, next-custom-transforms
   └─ --no-deps オプション: 依存クレートのドキュメントを除外
3. ドキュメント出力
   └─ target/doc/ ディレクトリにHTMLドキュメントが生成される
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[RUSTDOCFLAGS設定]
    B --> C[cargo doc実行]
    C --> D[対象パッケージのドキュメント生成]
    D --> E[target/doc/に出力]
    E --> F[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Rustコンパイルエラー | ソースコードにエラーがある場合 | コードを修正して再実行 |
| - | ツールチェーンエラー | nightlyツールチェーンが未インストール | rustup toolchain install nightly で対応 |
| - | パッケージ未検出 | 指定パッケージが見つからない | Cargo.tomlのworkspace設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

`set -euo pipefail` により、cargo docが失敗した場合はスクリプトが即座に終了する。CIジョブの失敗として報告される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 5クレート分のドキュメント生成 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 2GB以下 |

## 排他制御

排他制御は不要。ドキュメント生成は冪等な処理であり、並行実行の必要性はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | cargo doc実行中 | 各クレートのドキュメント生成進捗 |
| エラーログ | コンパイルエラー時 | Rustコンパイラのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ドキュメント生成失敗 | 1回 | CIジョブ通知 |

## 備考

- 対象Rustクレート:
  - `next-napi-bindings` - N-APIバインディング
  - `next-api` - Next.js API
  - `next-build` - ビルド処理
  - `next-core` - コア機能
  - `next-custom-transforms` - カスタムトランスフォーム
- `RUSTDOCFLAGS="-Z unstable-options --enable-index-page"` でトップレベルのインデックスページを生成
- `--no-deps` オプションにより、外部依存クレートのドキュメントは生成されない
- nightlyのRustツールチェーンが必要（`-Z unstable-options` フラグの使用のため）
- スクリプトは `set -euo pipefail` で厳格なエラーハンドリングを適用
- ソースコード: `scripts/deploy-turbopack-docs.sh`
