# バッチ設計書 50-inject-deploy-url

## 概要

本ドキュメントは、デプロイテスト用にtarballを展開しデプロイURLを注入するバッチ `inject-deploy-url` のバッチ設計書である。

### 本バッチの処理概要

`inject-deploy-url` バッチは、CI環境でデプロイテストを実行するために、プレビュービルドで生成されたNext.jsのtarballを展開し、`package.json` 内の `optionalDependencies` に含まれる `DEPLOY_URL` プレースホルダーを実際のVercelデプロイURLに置換する。処理後にtarballを再パッケージングする。

**業務上の目的・背景**：Next.jsのデプロイテスト（No.18 test-deploy）では、PRのプレビュービルドで生成されたパッケージを使用してテストを実行する。SWCネイティブバイナリパッケージは別のVercelデプロイメントでホスティングされており、その取得URLをtarball内のpackage.jsonに動的に注入する必要がある。本バッチはこのURL注入プロセスを自動化し、デプロイテストの実行基盤を提供する。

**バッチの実行タイミング**：CI環境でプレビューtarball生成後、デプロイテスト実行前に実行される。

**主要な処理内容**：
1. `public/` ディレクトリからNext.js tarball（非SWC）を検出
2. tarballをカレントディレクトリに移動して展開（`tar -xf`）
3. 展開されたpackage.jsonの `optionalDependencies` 内の `DEPLOY_URL` を `VERCEL_URL` 環境変数の値に置換
4. 更新されたpackage.jsonを書き込み
5. tarballを再パッケージング（`tar -czf`）
6. 再パッケージングされたtarballを `public/` ディレクトリに戻す

**前後の処理との関連**：No.9 create-preview-tarballsバッチで生成されたtarballを入力として受け取る。処理後のtarballはNo.18 test-deployバッチで使用される。

**影響範囲**：`public/` ディレクトリ内のNext.js tarball（package.json内のoptionalDependencies）が更新される。

## バッチ種別

データ変換 / ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIプレビュービルド後） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIワークフロー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| public/ディレクトリにtarballが存在 | create-preview-tarballsで生成されたtarballがあること |
| VERCEL_URL環境変数 | デプロイ先のVercel URLが設定されていること |
| Node.js実行環境 | Node.jsランタイムが利用可能であること |
| tarコマンド | tar コマンドが利用可能であること |

### 実行可否判定

`public/` ディレクトリ内にSWCでないtarball（`-swc` を含まないファイル）が存在する場合に処理を実行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VERCEL_URL | 環境変数 | Yes | - | VercelのデプロイURL（DEPLOY_URLの置換先） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| public/{next-tarball}.tgz | tarball | Next.jsのプレビュービルドtarball |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| public/{next-tarball}.tgz | tarball | URL注入後の再パッケージングされたtarball |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のtarballと同じファイル名 |
| 出力先 | public/ |
| 文字コード | UTF-8 (package.json) |
| 区切り文字 | - (tarball/JSON) |

## 処理フロー

### 処理シーケンス

```
1. tarballファイルの検出
   ├─ public/ ディレクトリの内容を読み取り
   └─ '-swc' を含まないファイルをNext.js tarballとして特定
2. tarballの移動と展開
   ├─ public/ からカレントディレクトリにリネーム（fs.rename）
   └─ tar -xf でtarballを展開
3. package.jsonの読み込みと更新
   ├─ package/package.json を読み込み
   ├─ optionalDependencies内の各キーの値からDEPLOY_URLをVERCEL_URLに置換
   └─ 更新されたpackage.jsonを書き込み
4. tarballの再パッケージング
   ├─ 元のtarballファイルを削除（fs.unlink）
   └─ tar -czf でpackageディレクトリをtarball化
5. tarballの復帰
   └─ カレントディレクトリからpublic/にリネーム
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[public/からtarball検出]
    B --> C[tarballをカレントディレクトリに移動]
    C --> D[tar -xf で展開]
    D --> E[package.json読み込み]
    E --> F[optionalDependenciesのDEPLOY_URLをVERCEL_URLに置換]
    F --> G[package.json書き込み]
    G --> H[元のtarball削除]
    H --> I[tar -czf で再パッケージング]
    I --> J[tarballをpublic/に戻す]
    J --> K[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | tarball検出失敗 | public/ディレクトリに対象tarballがない | エラー出力してexit(1) |
| - | tar展開エラー | tarコマンドが失敗 | 非ゼロ終了コードでPromise reject |
| - | ファイル読み書きエラー | package.jsonの読み書きに失敗 | エラーcatchしてexit(1) |
| - | tar再パッケージングエラー | tar圧縮コマンドが失敗 | 非ゼロ終了コードでPromise reject |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

main関数全体がtry-catchでラップされており、エラー発生時はエラーをコンソールに出力し `process.exit(1)` で終了する。CIジョブの失敗として報告される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | なし（処理中断時はtarballが不完全な状態になる可能性がある） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（1 tarball） |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 256MB以下 |

## 排他制御

排他制御は不要。CI環境ではジョブ単位で独立して実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | エラー発生時 | エラー詳細とスタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理失敗 | 1回 | CIジョブ通知 |

## 備考

- tarball検出ロジック: `public/` ディレクトリ内で `-swc` を含まないファイルをNext.js本体のtarballとして特定
- URL置換対象: `optionalDependencies` 内の全キーの値に含まれる `DEPLOY_URL` 文字列
- `VERCEL_URL` 環境変数はVercelデプロイメント時に自動的に設定される
- tarの展開・再パッケージングはspawnによる子プロセスで実行（shell: true）
- 展開先のディレクトリ名は `package`（npm packの標準出力形式）
- 処理中の一時ファイルはカレントディレクトリに作成され、処理完了後にpublic/に戻される
- ソースコード: `scripts/inject-deploy-url.js`
