# バッチ設計書 7-publish-native

## 概要

本ドキュメントは、SWCネイティブバイナリを各プラットフォーム向けnpmパッケージとして公開する `publish-native` バッチの設計書である。バイナリのコピーとバージョン更新を行った後にnpm publishを実行する。

### 本バッチの処理概要

`publish-native` は、RustベースのSWCネイティブバイナリを各プラットフォーム（darwin-arm64、linux-x64-gnu等）向けのnpmパッケージとして公開するバッチ処理である。ネイティブバイナリとWASMバイナリの両方を対象とする。

**業務上の目的・背景**：Next.jsのSWCコンパイラはプラットフォームごとにネイティブバイナリが異なる。`@next/swc-darwin-arm64` 等のプラットフォーム固有パッケージとしてnpmに公開することで、ユーザーのインストール時に適切なバイナリが自動選択される（optionalDependencies経由）。WASMビルドも提供することで、ネイティブバイナリが利用できない環境でのフォールバックを実現する。

**バッチの実行タイミング**：リリースプロセスの一部として `publish-release` と並行して実行される。

**主要な処理内容**：
1. `@next/swc` パッケージからバージョン情報を取得
2. ネイティブバイナリの各プラットフォームパッケージへのコピー
3. 各プラットフォームパッケージの package.json バージョン更新
4. ネイティブバイナリパッケージのnpm publish（並列、セマフォ制御）
5. WASMパッケージ（web/nodejs）の名前・バージョン更新とnpm publish
6. `packages/next/package.json` の optionalDependencies 更新

**前後の処理との関連**：`swc-build-native` によるネイティブバイナリビルドが前提。`start-release` によるバージョン設定後に実行される。

**影響範囲**：npmレジストリ上の `@next/swc-*` パッケージ、`@next/swc-wasm-*` パッケージ、`packages/next/package.json` のoptionalDependencies。

## バッチ種別

リリース処理（ネイティブバイナリ公開）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリースごと |
| 実行時刻 | リリースプロセス中 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネイティブバイナリ | packages/next-swc/native/ にビルド済みバイナリが存在 |
| NPM_TOKEN | npm公開用トークンが設定されていること |
| WASMビルド | crates/wasm/pkg-web/, pkg-nodejs/ にビルド済み |

### 実行可否判定

`@next/swc/package.json` からバージョンを読み取れること。各プラットフォームのバイナリファイルが存在すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NPM_TOKEN | 環境変数 | Yes | なし | npm認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| @next/swc/package.json | JSON | バージョン情報の参照元 |
| packages/next-swc/native/*.node | バイナリ | ネイティブバイナリファイル |
| crates/next-napi-bindings/npm/ | ディレクトリ | プラットフォーム別パッケージ定義 |
| crates/wasm/pkg-web/ | ディレクトリ | WASM webパッケージ |
| crates/wasm/pkg-nodejs/ | ディレクトリ | WASM nodejsパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| npmレジストリ | npm package | @next/swc-{platform} パッケージ |
| npmレジストリ | npm package | @next/swc-wasm-web パッケージ |
| npmレジストリ | npm package | @next/swc-wasm-nodejs パッケージ |
| packages/next/package.json | JSON | optionalDependencies バージョン更新 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | packages/next/package.json |
| 出力先 | packages/next/ |
| 文字コード | UTF-8 |
| 区切り文字 | JSON形式 |

## 処理フロー

### 処理シーケンス

```
1. バージョン取得
   └─ @next/swc/package.json からバージョン読み取り
2. プラットフォーム一覧取得
   └─ crates/next-napi-bindings/npm/ のサブディレクトリを列挙
3. ネイティブバイナリ公開（並列、Sema(2)）
   └─ 各プラットフォームについて:
      a. バイナリファイルをパッケージディレクトリにコピー
      b. package.json のバージョンを更新
      c. npm publish --access public [--tag canary]
4. WASMパッケージ公開
   └─ web/nodejs それぞれについて:
      a. package.json の name を @next/swc-wasm-{target} に設定
      b. バージョンを更新
      c. repository情報を追加
      d. npm publish --access public [--tag canary]
5. next/package.json の optionalDependencies 更新
   └─ 各プラットフォームの @next/swc-{platform} を現在バージョンに更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: publish-native] --> B[バージョン情報取得]
    B --> C[プラットフォーム一覧取得]
    C --> D[ネイティブバイナリ公開（並列）]
    D --> E[各プラットフォームにバイナリコピー]
    E --> F[package.json バージョン更新]
    F --> G[npm publish]
    G --> H[WASMパッケージ公開]
    H --> I[web/nodejs パッケージ名・バージョン更新]
    I --> J[npm publish]
    J --> K[next/package.json optionalDependencies更新]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BINARY_NOT_FOUND | ファイル不在 | プラットフォームバイナリが存在しない | swc-build-nativeを実行 |
| NPM_PUBLISH_FAILED | 公開エラー | npm publish失敗 | npmレジストリの状態を確認 |
| ALREADY_PUBLISHED | 重複公開 | 同一バージョンが公開済み | エラーとして無視（正常扱い） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（個別プラットフォームの失敗は他に影響しない） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

個別プラットフォームの公開失敗時は、そのプラットフォームのみ手動で再公開する。他プラットフォームの公開はブロックされない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | プラットフォーム単位 |
| コミットタイミング | 各プラットフォームのpublish成功時 |
| ロールバック条件 | 一部失敗時も他プラットフォームの公開は維持 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ネイティブ: 約10プラットフォーム + WASM: 2パッケージ |
| 目標処理時間 | 数分 |
| メモリ使用量上限 | 通常のNode.jsプロセスメモリ |

## 排他制御

セマフォ（Sema(2)）により、同時npm publish数を最大2に制限。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各プラットフォーム | npm publishの標準出力（stdio: inherit） |
| エラーログ | 公開失敗時 | "Failed to publish" {platform} |
| 無視ログ | 重複公開時 | "Ignoring already published error" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 公開失敗プラットフォーム数 | 1件以上 | コンソール出力（process.exit(1)） |
| 処理時間 | 10分 | CI/CD通知 |

## 備考

- エントリポイント: `scripts/publish-native.js`
- canaryバージョン時は `--tag canary` が自動付与される
- WASM パッケージ名は `@next/swc-wasm-web` と `@next/swc-wasm-nodejs`
- ネイティブバイナリのファイル名パターン: `next-swc.{platform}.node`
- 個別プラットフォームの失敗は他プラットフォームの公開をブロックしない設計（エラーはcatch内でログ出力のみ）
