---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-code-freeze

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **リリースプロセスにおける実行順序**：運用フローの根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/code-freeze.js` - メインスクリプトファイル
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CODE_FREEZE_TOKEN環境変数が必須 | E-01 (L1-5: `process.env.CODE_FREEZE_TOKEN`) | ○ |
| C-02 | --typeオプションでenable/disableを指定 | E-01 (L78-84: `process.argv.indexOf('--type')`) | ○ |
| C-03 | コードフリーズルールのcontext名は"Potentially publish release" | E-01 (L8: `context: 'Potentially publish release'`) | ○ |
| C-04 | app_idは15368 | E-01 (L9: `app_id: 15368`) | ○ |
| C-05 | GitHub API エンドポイント repos/vercel/next.js/branches/canary/protection を使用 | E-01 (L14, L34) | ○ |
| C-06 | GitHub API バージョン 2022-11-28 を使用 | E-01 (L20: `'X-GitHub-Api-Version': '2022-11-28'`) | ○ |
| C-07 | enable時にルール未追加ならcontextsに追加 | E-01 (L92-99) | ○ |
| C-08 | disable時にルールが存在すればcontextsからフィルタ除去 | E-01 (L100-111) | ○ |
| C-09 | 既にenable済みの場合"Already enabled"を出力 | E-01 (L93-96) | ○ |
| C-10 | 既にdisable済みの場合"Already disabled"を出力 | E-01 (L101-103) | ○ |
| C-11 | APIエラー時にステータスコードとエラーメッセージを出力 | E-01 (L27-30, L46-49) | ○ |
| C-12 | PUTメソッドでブランチ保護ルールを更新 | E-01 (L16: `method: 'PUT'`) | ○ |
| C-13 | 現在のルールからrestrictions.usersのlogin、teams.slugなどを抽出 | E-01 (L69-73) | ○ |
| C-14 | start-releaseの前にenable、publish-release完了後にdisableする | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リリースプロセスにおけるcode-freezeの実行タイミングは、ソースコード内に明示的な記述がなく運用上の慣行に基づく推定
  - 候補：リリース手順書 / CI/CDワークフロー定義 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実行順序は運用上の推定だが、enable/disableの冪等性により誤実行の影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] CODE_FREEZE_TOKENに必要なGitHubトークンのスコープ（admin:repo）が正しいか確認
- [ ] リリースプロセスにおけるcode-freezeの実行タイミングが運用に合致しているか確認
