---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：13-test-unit

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間5分以内）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` - scripts.test-unit定義
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `package.json` - devDependencies（jest, jest-junit等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jestテストランナーを使用する | E-01 (L17: `"test-unit": "jest test/unit/ packages/next/ packages/font"`) | ○ |
| C-02 | test/unit/, packages/next/, packages/fontの3ディレクトリが対象 | E-01 (L17) | ○ |
| C-03 | Jest 29.7.0を使用 | E-03 (L224: `"jest": "29.7.0"`) | ○ |
| C-04 | Node.js 20.9.0以上が必要 | E-01 (L308: `"node": ">=20.9.0"`) | ○ |
| C-05 | jest-junitでレポート出力をサポート | E-03 (L228: `"jest-junit": "16.0.0"`) | ○ |
| C-06 | pnpm testonlyでjest --runInBand実行が可能 | E-01 (L61: `"testonly": "jest --runInBand"`) | ○ |
| C-07 | run-tests.jsによるデフォルトリトライ2回 | E-01参照、run-tests.js (L54: `DEFAULT_NUM_RETRIES = 2`) | ○ |
| C-08 | CIパイプラインで毎PR・毎コミット時に自動実行 | E-02 (バッチ一覧の説明) | ○ |
| C-09 | pnpm 9.6.0を使用 | E-01 (L311: `"pnpm": "9.6.0"`) | ○ |
| C-10 | 目標処理時間5分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間はユニットテストの軽量性からの推定であり、公式な要件やベンチマーク結果に基づいていない
  - 候補：CI実行ログ / パフォーマンスベンチマーク / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パフォーマンス要件は推定だが、テスト実行バッチであり目標時間の厳密性は低い

## 6) レビュアーチェックリスト（最小）
- [ ] テスト対象ディレクトリの範囲が正しいか確認
- [ ] CI環境でのJUnit出力設定が記載通りか確認
