---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：16-test-dev-webpack

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間60分以内）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` - scripts定義（test-dev-webpack, with-webpack, test-dev-inner, test-dev）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `run-tests.js` - テストランナー設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IS_WEBPACK_TEST=1を設定する | E-01 (L110: `"with-webpack": "cross-env IS_WEBPACK_TEST=1"`) | ○ |
| C-02 | NEXT_TEST_MODE=devを設定する | E-01 (L18: `cross-env NEXT_TEST_MODE=dev`) | ○ |
| C-03 | HEADLESS=trueでヘッドレスモード | E-01 (L62) | ○ |
| C-04 | test-dev-webpackはwith-webpackとtest-dev-innerを呼び出す | E-01 (L20: `"pnpm run with-webpack pnpm test-dev-inner"`) | ○ |
| C-05 | test-devのデフォルトはtest-dev-webpack | E-01 (L19: `"test-dev": "pnpm run test-dev-webpack"`) | ○ |
| C-06 | jest --runInBandで実行 | E-01 (L61) | ○ |
| C-07 | run-tests.jsのデフォルトリトライ回数は2回 | E-03 (L54) | ○ |
| C-08 | テスト対象はe2e/development/integrationディレクトリ | E-03 (L100付近) | ○ |
| C-09 | Playwright Chromiumを使用 | E-01 (devDependencies) | ○ |
| C-10 | Webpack 5.98.0を使用 | E-01 (L300: `"webpack": "5.98.0"`) | ○ |
| C-11 | 目標処理時間60分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の処理時間は推定値
  - 候補：CI実行ログ / GitHub Actions workflow定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パフォーマンス要件は推定値だが、テストバッチの時間制約は柔軟

## 6) レビュアーチェックリスト（最小）
- [ ] with-webpackの環境変数設定が正しいか確認
- [ ] test-devのデフォルトがtest-dev-webpackである点を認識しているか確認
