---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：18-test-deploy

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間60分以内）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` - scripts定義（test-deploy, test-deploy-webpack, test-deploy-turbo, test-deploy-inner）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: `scripts/test-new-tests.mjs` - デプロイテストフィルタ参照（deploy-tests-manifest.json）
- E-04: `run-tests.js` - テストランナー設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NEXT_TEST_MODE=deployを設定する | E-01 (L38: `cross-env NEXT_TEST_MODE=deploy`) | ○ |
| C-02 | test-deployのデフォルトはtest-deploy-webpack | E-01 (L39: `"test-deploy": "pnpm run test-deploy-webpack"`) | ○ |
| C-03 | test-deploy-webpackはwith-webpackとtest-deploy-innerを呼び出す | E-01 (L40) | ○ |
| C-04 | test-deploy-turboはIS_TURBOPACK_TEST=1, TURBOPACK_BUILD=1を設定 | E-01 (L41) | ○ |
| C-05 | deploy-tests-manifest.jsonによるフィルタリングをサポート | E-03 (L143: `'test/deploy-tests-manifest.json'`) | ○ |
| C-06 | HEADLESS=trueでヘッドレスモード | E-01 (L62) | ○ |
| C-07 | jest --runInBandで実行 | E-01 (L61) | ○ |
| C-08 | run-tests.jsのデフォルトリトライ回数は2回 | E-04 (L54) | ○ |
| C-09 | Webpack/Turbopack両方を選択可能 | E-01 (L39-41) | ○ |
| C-10 | test-deploy-innerはtestheadlessを呼び出す | E-01 (L38) | ○ |
| C-11 | Playwright Chromiumを使用 | E-01 (devDependencies) | ○ |
| C-12 | 目標処理時間60分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の処理時間は推定値
  - 候補：CI実行ログ / GitHub Actions workflow定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] deploy-tests-manifest.jsonの内容とフィルタ適用の正確性を確認
- [ ] デプロイ環境への接続設定が適切か確認
