---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-test-new-tests

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/test-new-tests.mjs` - メインスクリプトファイル
- E-02: `scripts/get-changed-tests.mjs` - 変更テスト検出スクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --mode, --group, --flake-detectionのCLIオプションをサポート | E-01 (L14-17: yargs定義) | ○ |
| C-02 | modeはdev/deploy/startの3種類 | E-01 (L23: `['dev', 'deploy', 'start'].includes(testMode)`) | ○ |
| C-03 | フレーク検出モードは3回繰り返し | E-01 (L21: `const attempts = isFlakeDetectionMode ? 3 : 1`) | ○ |
| C-04 | getChangedTests()で差分テストを検出 | E-01 (L44-45) | ○ |
| C-05 | テスト0件時は"No added/changed tests detected"を出力 | E-01 (L83: `console.log('No added/changed tests detected')`) | ○ |
| C-06 | run-tests.js -c 1 --retries 0で実行 | E-01 (L87: `['run-tests.js', '-c', '1', '--retries', '0']`) | ○ |
| C-07 | deployモードでアーティファクトURLをリトライ付きで検証 | E-01 (L103-126: fetchWithRetry) | ○ |
| C-08 | アーティファクト検証は5回リトライ、5秒間隔 | E-01 (L103: `retries = 5, timeout = 5000`) | ○ |
| C-09 | フレーク検出+非deployモードではTurbopack環境変数を設定 | E-01 (L152-168: IS_TURBOPACK_TEST=1) | ○ |
| C-10 | deployモードではIS_WEBPACK_TEST=1を設定 | E-01 (L180: `IS_WEBPACK_TEST: '1'`) | ○ |
| C-11 | test/e2eはdev+prod+deployの全モードに分類 | E-02 (L58-61) | ○ |
| C-12 | test/integrationはdev+prodに分類 | E-02 (L62-64) | ○ |
| C-13 | test/prodはprodTestsに分類 | E-02 (L65-66) | ○ |
| C-14 | test/developmentはdevTestsに分類 | E-02 (L67-68) | ○ |
| C-15 | canaryブランチではスキップ | E-02 (L18-20: `if (isCanary)`) | ○ |
| C-16 | 目標処理時間30分以内（フレーク検出時90分以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は変更テスト数に依存するため一概に言えず、推定値
  - 候補：CI実行ログ / 変更テスト数の統計

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理時間は変更テスト数に依存し、推定値は保守的な値

## 6) レビュアーチェックリスト（最小）
- [ ] テストモード別の分類ロジックが正確か確認
- [ ] アーティファクト検証のリトライロジックが適切か確認
- [ ] フレーク検出モードでのTurbopack/Webpack切り替えが正しいか確認
