---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-next-test

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **メモリ使用量上限2048MB**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-test.ts` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サポートされるテストランナーはplaywrightのみ | E-01 (L22: `SUPPORTED_TEST_RUNNERS_LIST = ['playwright']`) | ○ |
| C-02 | @playwright/testが必要な依存パッケージ | E-01 (L28-30: `requiredPackagesByTestRunner`) | ○ |
| C-03 | experimental.testProxy: trueが必須 | E-01 (L75-79) | ○ |
| C-04 | テストランナーの優先順位: CLI > config > default | E-01 (L70-73) | ○ |
| C-05 | experimental.defaultTestRunnerで設定可能 | E-01 (L72) | ○ |
| C-06 | directoryが無効なパスの場合テストランナー引数にフォールバック | E-01 (L48-54) | ○ |
| C-07 | directoryがNext.jsプロジェクトでない場合もフォールバック | E-01 (L56-67) | ○ |
| C-08 | 依存パッケージ未インストール時に自動インストール | E-01 (L96-121: `checkRequiredDeps`) | ○ |
| C-09 | playwright installでブラウザバイナリをインストール | E-01 (L103-114) | ○ |
| C-10 | playwright.config.ts/jsをfindUpで検索 | E-01 (L130-135) | ○ |
| C-11 | 設定ファイル未存在時にデフォルト設定を生成 | E-01 (L137-168) | ○ |
| C-12 | TypeScript判定はverifyTypeScriptSetupで実行 | E-01 (L140-152) | ○ |
| C-13 | 設定ファイルはnext/experimental/testmode/playwrightのdefineConfigを使用 | E-01 (L189-198) | ○ |
| C-14 | 設定ファイル存在時はplaywright testコマンドを実行 | E-01 (L170-186) | ○ |
| C-15 | メモリ使用量上限2048MB | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メモリ使用量上限はPlaywrightの実行特性からの推定であり、公式な制限値ではない
  - 候補：Playwright公式ドキュメント / 実測データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メモリ使用量は推定値だが、実行環境に依存するパラメータ

## 6) レビュアーチェックリスト（最小）
- [ ] experimental.testProxy設定の要件が正確か確認
- [ ] directory引数のフォールバックロジックが正確に記述されているか確認
- [ ] 自動生成されるplaywright.config内容が正しいか確認
