---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-lint バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` scripts.lint 定義
- E-02: `package.json` scripts.test-types 定義
- E-03: `package.json` scripts.lint-typescript 定義
- E-04: `package.json` scripts.prettier-check 定義
- E-05: `package.json` scripts.lint-eslint 定義
- E-06: `package.json` scripts.lint-ast-grep 定義
- E-07: `package.json` scripts.lint-language 定義
- E-08: `package.json` engines フィールド
- E-09: `package.json` packageManager フィールド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lintスクリプトはrun-pで6つのタスクを並列実行する | E-01 | ○ |
| C-02 | test-typesはtsc --noEmitを実行する | E-02 | ○ |
| C-03 | lint-typescriptはturbo run typescriptを実行する | E-03 | ○ |
| C-04 | prettier-checkはprettier --check .を実行する | E-04 | ○ |
| C-05 | lint-eslintはeslint --config eslint.cli.config.mjsを実行する | E-05 | ○ |
| C-06 | lint-ast-grepはast-grep scanを実行する | E-06 | ○ |
| C-07 | lint-languageはalex .を実行する | E-07 | ○ |
| C-08 | Node.js >= 20.9.0が必要 | E-08 | ○ |
| C-09 | pnpm 9.6.0が必要 | E-09 | ○ |
| C-10 | lintはコード品質検証バッチである | E-01 | ○ |
| C-11 | 読み取り専用処理でファイル変更を行わない | E-01 | ○ |
| C-12 | lint-fixとの関連がある | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がpackage.jsonの定義から直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonのlintスクリプト定義が最新であることを確認
- [ ] 各並列タスクの設定ファイルが存在することを確認
