---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-lint-fix バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `package.json` scripts.lint-fix 定義
- E-02: `package.json` scripts.prettier-fix 定義
- E-03: `package.json` scripts.lint-eslint 定義
- E-04: `package.json` engines フィールド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lint-fixはprettier-fixとlint-eslint --fixを順次実行する | E-01 | ○ |
| C-02 | prettier-fixはprettier --write .を実行する | E-02 | ○ |
| C-03 | lint-eslintはeslint --config eslint.cli.config.mjsを使用する | E-03 | ○ |
| C-04 | Prettierが先に実行され、その後ESLintが実行される | E-01 | ○ |
| C-05 | &&による連結でPrettier失敗時はESLintが実行されない | E-01 | ○ |
| C-06 | Node.js >= 20.9.0が必要 | E-04 | ○ |
| C-07 | pnpm 9.6.0が必要 | E-04 | ○ |
| C-08 | ファイルを直接上書きする処理である | E-01, E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がpackage.jsonの定義から直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonのlint-fixスクリプト定義が最新であることを確認
- [ ] Prettierフォーマット設定が期待通りであることを確認
