---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-check-precompiled バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/check-pre-compiled.sh` スクリプト本体
- E-02: `package.json` scripts.check-precompiled 定義
- E-03: `package.json` scripts.types-and-precompiled 定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | packages/nextディレクトリに移動して処理を行う | E-01 | ○ |
| C-02 | 4つのwebpackランタイムファイルをコピーする | E-01 | ○ |
| C-03 | pnpm run ncc-compiledを実行する | E-01 | ○ |
| C-04 | git status -sで変更を検出する | E-01 | ○ |
| C-05 | 変更があればgit diff -a --statを表示してexit 1 | E-01 | ○ |
| C-06 | set -eでエラー時に即座に終了する | E-01 | ○ |
| C-07 | check-precompiledは./scripts/check-pre-compiled.shを呼び出す | E-02 | ○ |
| C-08 | types-and-precompiledタスクの一部として実行される | E-03 | ○ |
| C-09 | コピー元はnode_modules/webpack/ | E-01 | ○ |
| C-10 | コピー先はsrc/bundles/webpack/packages/ | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がシェルスクリプトおよびpackage.jsonから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] check-pre-compiled.shの内容が最新であることを確認
- [ ] コピー対象のwebpackファイルパスが正しいことを確認
