---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-check-manifests バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/check-manifests.js` スクリプト本体
- E-02: `scripts/check-manifests.js` collectPaths関数
- E-03: `scripts/check-manifests.js` main関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | errors/manifest.jsonを読み込んでルーティングパスを抽出する | E-01, E-03 | ○ |
| C-02 | collectPaths関数でroutesを再帰的に走査する | E-02 | ○ |
| C-03 | redirectのあるルートはスキップする | E-02 | ○ |
| C-04 | errors/**/*.mdパターンでファイルを走査する | E-03 | ○ |
| C-05 | template.mdは検証対象から除外される | E-03 | ○ |
| C-06 | マニフェスト未登録ファイルを検出する | E-03 | ○ |
| C-07 | マニフェストのパスに対応するファイルの存在をチェックする | E-03 | ○ |
| C-08 | 不整合がある場合はprocess.exit(1)で終了する | E-03 | ○ |
| C-09 | 成功時は"success"を出力する | E-03 | ○ |
| C-10 | fs.constants.F_OKでファイル存在を確認する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がスクリプトソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] check-manifests.jsの処理ロジックが最新であることを確認
- [ ] errors/manifest.jsonの構造が想定通りであることを確認
