---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-validate-externals-doc バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/validate-externals-doc.js` スクリプト本体
- E-02: `scripts/validate-externals-doc.js` validate関数
- E-03: `package.json` scripts.validate-externals-doc 定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | server-external-packages.jsoncをJSON5でパースする | E-01 | ○ |
| C-02 | App Routerドキュメントのパスが正しい | E-01 | ○ |
| C-03 | Pages Routerドキュメントのパスが正しい | E-01 | ○ |
| C-04 | "opt-ed out:"セクション以降からパッケージ名を抽出する | E-02 | ○ |
| C-05 | バッククォートで囲まれたパッケージ名を解析する | E-02 | ○ |
| C-06 | 余分パッケージと不足パッケージを検出する | E-02 | ○ |
| C-07 | 両方のドキュメントが整合する場合のみexit 0 | E-01 | ○ |
| C-08 | 不整合時は"server externals doc out of sync!"を出力する | E-02 | ○ |
| C-09 | next/dist/compiled/json5を使用してパースする | E-01 | ○ |
| C-10 | package.jsonでvalidate-externals-docスクリプトが定義されている | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がスクリプトソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] validate-externals-doc.jsの処理ロジックが最新であることを確認
- [ ] 対象ドキュメントのパスが変更されていないことを確認
