---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-check-error-codes バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/check-error-codes.js` スクリプト本体
- E-02: `package.json` scripts.check-error-codes 定義
- E-03: `packages/next/taskfile.js` check_error_codesタスク定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .errorsディレクトリが存在しなければexit 0で終了する | E-01 | ○ |
| C-02 | errors.jsonを読み込んで既存エラーを取得する | E-01 | ○ |
| C-03 | 次番コードは既存最大コード+1で算出する | E-01 | ○ |
| C-04 | 各エラーファイルのerrorMessageフィールドを取得する | E-01 | ○ |
| C-05 | 既存メッセージとの重複チェックを行う | E-01 | ○ |
| C-06 | errors.jsonをJSON.stringify(null, 2) + os.EOLで書き出す | E-01 | ○ |
| C-07 | .errorsディレクトリをrecursive: trueで削除する | E-01 | ○ |
| C-08 | 処理後は常にexit 1で終了する | E-01 | ○ |
| C-09 | package.jsonでcheck-error-codesスクリプトが定義されている | E-02 | ○ |
| C-10 | taskr buildタスク内でcompileの後に実行される | E-03 | ○ |
| C-11 | CI環境ではエラーメッセージを表示してexit 1 | E-03 | ○ |
| C-12 | ローカル環境ではcompileタスクを再実行する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] check-error-codes.jsの処理ロジックが最新であることを確認
- [ ] taskfile.jsのcheck_error_codesタスク定義が最新であることを確認
