---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：29-sync-react バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Actionsワークフロー定義**：ワークフローYAMLの直接確認なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/sync-react.js` スクリプト本体
- E-02: `scripts/sync-react.js` sync関数
- E-03: `scripts/sync-react.js` main関数
- E-04: `scripts/sync-react.js` getSchedulerVersion関数
- E-05: `scripts/sync-react.js` findHighestNPMReactVersion関数
- E-06: `scripts/sync-react.js` getChangelogFromGitHub関数
- E-07: `scripts/sync-react.js` 定数定義（repoOwner, pullRequestLabels等）
- E-08: `package.json` scripts.sync-react 定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npmレジストリから最新canaryバージョンを取得する | E-05 | ○ |
| C-02 | schedulerバージョンはreact-domの依存関係から取得する | E-04 | ○ |
| C-03 | devDependenciesとpnpm overridesのバージョン文字列を置換する | E-02 | ○ |
| C-04 | experimentalとcanaryの両チャネルを更新する | E-03 | ○ |
| C-05 | ピア依存関係参照ファイル一覧が正しい | E-01 | ○ |
| C-06 | ライブラリマニフェスト一覧が正しい | E-01 | ○ |
| C-07 | アプリケーションマニフェスト一覧が正しい | E-01 | ○ |
| C-08 | --create-pullオプションでPRを作成する | E-03 | ○ |
| C-09 | --actorと--create-pullの組み合わせバリデーション | E-03 | ○ |
| C-10 | GITHUB_TOKENが--create-pull時に必須 | E-03 | ○ |
| C-11 | 既存ブランチがある場合はスキップする | E-03 | ○ |
| C-12 | PRラベルはtype: react-sync | E-07 | ○ |
| C-13 | PRレビュアーはeps1lon | E-07 | ○ |
| C-14 | pnpm installは--no-frozen-lockfileで実行 | E-03 | ○ |
| C-15 | ncc-compiledでベンダーファイルを再生成する | E-03 | ○ |
| C-16 | GitHubコミットログから変更履歴を生成する | E-06 | ○ |
| C-17 | activePagesRouterReactは^19.0.0に固定 | E-01 | ○ |
| C-18 | GitHub Actionsワークフローによる定期実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GitHub Actionsワークフロー定義ファイル（.github/workflows/配下）を直接確認していないため、定期実行の設定を確認できていない
  - 候補: `.github/workflows/sync-react.yml` / `.github/workflows/update-react.yml`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - GitHub Actionsワークフロー定義の直接確認が不足

## 6) レビュアーチェックリスト（最小）
- [ ] sync-react.jsの処理ロジックが最新であることを確認
- [ ] GitHub Actionsワークフロー定義でsync-reactの定期実行が設定されていることを確認
- [ ] 更新対象ファイルリストが最新であることを確認
- [ ] activePagesRouterReactの設定値が現在の方針と一致することを確認
