---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：3-swc-build-native バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **ビルド時間の見積もり**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/build-native.ts` - バッチエントリポイント
- E-02: `packages/next/src/build/swc/generated-native.d.ts` - 型定義出力先（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pnpm run build-nativeをpackages/next-swcで実行 | E-01 (L14-26) | ○ |
| C-02 | 環境変数NODE_ENV, CARGO_TERM_COLOR, TTYを設定 | E-01 (L22-24) | ○ |
| C-03 | shell: trueで実行 | E-01 (L19) | ○ |
| C-04 | stdio: inheritで出力 | E-01 (L25) | ○ |
| C-05 | generated-native.d.tsに型定義を統合 | E-01 (L42-64) | ○ |
| C-06 | GENERATED-TYPES-BELOWマーカーで分割 | E-01 (L51, L59) | ○ |
| C-07 | DO NOT MANUALLY EDIT注記を自動付与 | E-01 (L53-54) | ○ |
| C-08 | Prettierでフォーマット実行 | E-01 (L65-71) | ○ |
| C-09 | preferLocal: trueでPrettier実行 | E-01 (L70) | ○ |
| C-10 | メイン実行時はprocess.argv経由で起動 | E-01 (L35-40) | ○ |
| C-11 | エラー時はprocess.exit(1) | E-01 (L38) | ○ |
| C-12 | buildNativeArgs引数が透過的にCargo buildに渡される | E-01 (L14) | ○ |
| C-13 | ビルド時間がインクリメンタル数十秒/フルビルド数分～十数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド時間の見積もりはハードウェアやプロジェクト規模に依存するため、ソースコードから定量的根拠を得られない
  - 候補：CI/CDの実行ログ / ローカルベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローはソースコードから直接読み取り可能
- 0: 低リスク - ファイルパスと処理内容はソースコードと一致
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] packages/next-swcのbuild-nativeスクリプトが正しくCargo buildを呼び出しているか確認
- [ ] generated-native.d.tsの出力パスが最新であるか確認
- [ ] Prettierの設定が型定義ファイルに適用可能か確認
