---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-update-google-fonts バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/update-google-fonts.js` スクリプト本体
- E-02: `scripts/update-google-fonts.js` フォント解析ループ
- E-03: `scripts/update-google-fonts.js` 型定義生成ロジック
- E-04: `scripts/update-google-fonts.js` ファイル書き出しロジック
- E-05: `package.json` scripts.update-google-fonts 定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Google Fonts APIのURL（https://fonts.google.com/metadata/fonts）からメタデータを取得する | E-01 | ○ |
| C-02 | familyMetadataListからフォント情報を取得する | E-01 | ○ |
| C-03 | 除外サブセットはmenu, japanese, korean, chinese-simplified, chinese-hongkong, chinese-traditional | E-02 | ○ |
| C-04 | バリアント末尾がiの場合はitalicスタイルとして判定する | E-02 | ○ |
| C-05 | axes.length > 0でバリアブルフォントを判定する | E-02 | ○ |
| C-06 | バリアブルフォントにはvariableウェイトを追加する | E-02 | ○ |
| C-07 | 非weightの軸をoptionalAxesとして抽出する | E-02 | ○ |
| C-08 | フォント名の先頭が数字の場合はアンダースコアプレフィックスを付与する | E-03 | ○ |
| C-09 | スペースをアンダースコアに変換する | E-03 | ○ |
| C-10 | 出力先はpackages/font/src/google/index.tsとfont-data.json | E-04 | ○ |
| C-11 | Promise.allで2ファイルを並列書き出しする | E-04 | ○ |
| C-12 | font-data.jsonはJSON.stringify(null, 2)で整形する | E-04 | ○ |
| C-13 | バリアブルフォントではweightパラメータがオプショナルになる | E-03 | ○ |
| C-14 | 自動生成コメントがindex.tsの先頭に含まれる | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がスクリプトソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] update-google-fonts.jsの処理ロジックが最新であることを確認
- [ ] Google Fonts APIのレスポンス形式に変更がないことを確認
- [ ] 除外サブセットリストが最新の方針と一致することを確認
