---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-automated-update-workflow

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Actionsワークフロー定義の確認**：実際のcronスケジュールやconcurrency設定はワークフローYAMLファイルに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `scripts/automated-update-workflow.js` L1-103
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L32
- E-03: `scripts/sync-react.js`（バッチ一覧での参照）
- E-04: `scripts/update-google-fonts.js`（バッチ一覧での参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GITHUB_TOKENとSCRIPT環境変数が必須 | E-01 L7-22 | ○ |
| C-02 | Octokitを使用してGitHub APIと通信 | E-01 L2, L25 | ○ |
| C-03 | ブランチ名が`update/{BRANCH_NAME}-{timestamp}`形式 | E-01 L26 | ○ |
| C-04 | 更新スクリプトを`node ${SCRIPT}`で実行 | E-01 L28 | ○ |
| C-05 | Gitユーザー名がnextjs-bot | E-01 L30 | ○ |
| C-06 | Gitメールアドレスがit+nextjs-bot@vercel.com | E-01 L31 | ○ |
| C-07 | 変更ファイルがない場合はスキップ | E-01 L41-44 | ○ |
| C-08 | PRのbaseブランチがcanary | E-01 L65 | ○ |
| C-09 | PRに`run-react-18-tests`ラベルを付与 | E-01 L69-74 | ○ |
| C-10 | 既存の同一タイトルPRをクローズ | E-01 L78-95 | ○ |
| C-11 | 直近100件のオープンPRを検索 | E-01 L57 (per_page: 100) | ○ |
| C-12 | BRANCH_NAMEデフォルト値が"unknown" | E-01 L10 | ○ |
| C-13 | PR_TITLEデフォルト値が"Automated update" | E-01 L11 | ○ |
| C-14 | PR_BODYデフォルト値が空文字列 | E-01 L12 | ○ |
| C-15 | エラー時にprocess.exit(1)で終了 | E-01 L98-101 | ○ |
| C-16 | sync-reactやupdate-google-fontsと組み合わせて使用 | E-02, E-03, E-04 | ○ |
| C-17 | バッチカテゴリが「依存関係更新」 | E-02 | ○ |
| C-18 | GitHub Actionsのconcurrencyグループで排他制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GitHub Actionsワークフロー定義ファイル（.github/workflows/）が未確認のため、実際のスケジュール設定やconcurrency設定が検証できない
  - 候補：`.github/workflows/` 内の該当YAMLファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく処理フローの記述は正確
- 1: 中リスク - 排他制御に関する記述はワークフローYAML未確認のため推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義ファイルでconcurrency設定を確認
- [ ] GITHUB_TOKENに必要な権限スコープを確認
- [ ] 既存PRクローズのロジックが意図通りか確認（タイトル一致 && nextjs-botユーザー）
