---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：32-next-analyze

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **analyze関数の詳細動作**：build/analyzeモジュールの実装が未確認
  2. **出力ファイルの詳細仕様**：分析レポートの具体的な形式が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-analyze.ts` L1-62
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L33
- E-03: `packages/next/src/server/lib/cpu-profile`（import参照）
- E-04: `packages/next/src/build/analyze`（import参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPUプロファイル収集機能がある | E-01 L3-4 | ○ |
| C-02 | SIGTERMでexit 143 | E-01 L22-25 | ○ |
| C-03 | SIGINTでexit 130 | E-01 L26-29 | ○ |
| C-04 | mangling無効時に警告表示 | E-01 L33-37 | ○ |
| C-05 | profile有効時に警告表示 | E-01 L39-43 | ○ |
| C-06 | getProjectDirでディレクトリ取得 | E-01 L45 | ○ |
| C-07 | ディレクトリ不在時にprintAndExitで終了 | E-01 L47-49 | ○ |
| C-08 | analyze関数にdir、reactProductionProfiling等を渡す | E-01 L51-58 | ○ |
| C-09 | NextAnalyzeOptionsの型定義 | E-01 L12-19 | ○ |
| C-10 | picocolorsライブラリを使用 | E-01 L6 | ○ |
| C-11 | CLIエントリポイントのパス | E-01, E-02 | ○ |
| C-12 | build/analyzeモジュールに委譲 | E-01 L7 | ○ |
| C-13 | experimentalAppOnlyオプションがある | E-01 L13, L31 | ○ |
| C-14 | 分析レポートが.nextディレクトリに出力される | **根拠なし** | △ |
| C-15 | 処理時間が数分〜数十分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `packages/next/src/build/analyze`モジュールの実装が未確認のため、分析レポートの出力先と形式が検証できない
  - 候補：`packages/next/src/build/analyze.ts` / `packages/next/src/build/analyze/index.ts`
- パフォーマンス要件は推定値であり、実測データが不足

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - analyze関数の内部実装が未確認のため、出力仕様に不確実性がある
- 0: 低リスク - CLIオプションと入力パラメータの記述はソースコードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] `packages/next/src/build/analyze`モジュールの実装を確認し、出力仕様を検証
- [ ] バンドル分析レポートの具体的な出力形式を確認
- [ ] portオプションの動作（分析レポートサーバー）を確認
