---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-next-info

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-info.ts` L1-608
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L34

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | verboseオプションで詳細診断モード | E-01 L14-16, L600-606 | ○ |
| C-02 | getPackageVersionで各パッケージバージョン取得 | E-01 L55-61 | ○ |
| C-03 | loadConfigでNext.js設定読み込み | E-01 L63-72 | ○ |
| C-04 | getBinaryVersionでバイナリバージョン取得 | E-01 L78-91 | ○ |
| C-05 | npmレジストリからdist-tags取得 | E-01 L105-106 | ○ |
| C-06 | parseVersionInfoとgetStalenessでバージョン鮮度判定 | E-01 L109-115 | ○ |
| C-07 | NEXT_RSPACK環境変数でnext-rspackバージョン表示 | E-01 L142-145 | ○ |
| C-08 | OS情報（プラットフォーム、アーキテクチャ等）を収集 | E-01 L147-162 | ○ |
| C-09 | 古いバージョン時にcanary試行を推奨 | E-01 L164-168 | ○ |
| C-10 | verboseモードで5つの診断タスクを実行 | E-01 L270-531 | ○ |
| C-11 | WSL/Docker/CI検出 | E-01 L282-298 | ○ |
| C-12 | Node.js診断レポートでheap/sharedObjects取得 | E-01 L334-358 | ○ |
| C-13 | セキュリティのためcwd,commandLine,host等を削除 | E-01 L347-350 | ○ |
| C-14 | next-swcインストール確認でloadBindings使用 | E-01 L370-388 | ○ |
| C-15 | linux:ldd、darwin:otool/dyld_info、win32:dumpbin.exe | E-01 L475-528 | ○ |
| C-16 | 非対応プラットフォームでメッセージ表示して終了 | E-01 L258-267 | ○ |
| C-17 | タスクごとにpass/fail/skippedステータス | E-01 L22-24 | ○ |
| C-18 | レジストリアクセス失敗時に警告表示して継続 | E-01 L120-133 | ○ |
| C-19 | パッケージ未検出時に"N/A"を返す | E-01 L57-60 | ○ |
| C-20 | getSupportedArchTriplesで対応トリプル取得 | E-01 L186 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全主張の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] verboseモードの各診断タスクの出力形式が期待通りか確認
- [ ] プラットフォーム別の共有ライブラリチェックツールの動作を確認
