---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-analyze-dev-server-bundle

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/analyze-dev-server-bundle.js` L1-143
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L35

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5つのCLIオプション（open, verbose, json, list-modules, list-externals） | E-01 L26-30 | ○ |
| C-02 | バンドルパスがdist/compiled/dev-server/start-server.js | E-01 L33-36 | ○ |
| C-03 | レポートパスがdist/compiled/dev-server/bundle-report.html | E-01 L37-40 | ○ |
| C-04 | ANALYZE=1環境変数でビルド | E-01 L47-51 | ○ |
| C-05 | verbose時にANALYZE_REASONS=1を設定 | E-01 L50 | ○ |
| C-06 | `npx taskr next_bundle_dev_server`でビルド | E-01 L54 | ○ |
| C-07 | ビルド失敗時にexit(1) | E-01 L59-62 | ○ |
| C-08 | バンドルサイズをKB/MB単位で表示 | E-01 L65-73 | ○ |
| C-09 | モジュール一覧を"./dist/"パターンで抽出 | E-01 L80 | ○ |
| C-10 | 外部化モジュールをrequire()パターンで抽出 | E-01 L97-99 | ○ |
| C-11 | stats.jsonのパス表示 | E-01 L112-117 | ○ |
| C-12 | プラットフォーム別ブラウザ起動コマンド | E-01 L123-128 | ○ |
| C-13 | darwin:open, win32:start, その他:xdg-open | E-01 L124-128 | ○ |
| C-14 | ブラウザ起動失敗時にパスを表示 | E-01 L131-133 | ○ |
| C-15 | Tipsメッセージの表示 | E-01 L138-143 | ○ |
| C-16 | styled-jsxも外部化パターンに含む | E-01 L99 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから全主張の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなスクリプトで全処理がソースコードから検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] taskr next_bundle_dev_serverタスクの存在と動作を確認
- [ ] bundle-report.htmlの生成が正常に行われることを確認
